#ifndef __TERRAIN_H__
#define __TERRAIN_H__

#pragma warning (disable : 4786)

#include <lib3d/lib3d.h>

#include <lib3d/util2d/Texture.h>
#include <lib3d/util3d/Vector3d.h>
#include <lib3d/util2d/Perlin.h>

struct PlaneEqCache {
   float D;
   Vector3d normal;
   int i,j,triangle;
};

class Terrain {

public:

   Terrain(int size,int step = 1);
   ~Terrain();

   void  setScale(float x,float y,float z);
   bool  setTexture(char *path);
   void  setTexture(Texture *t);
   void  setStepSize(int ss);
   void  setFogDepth(float depth);
   void  setFogColor(float r,float g,float b);
   void  enableFog(bool f);
   bool  isFogEnabled();
   bool  load(char *path);
   void  generate(int octave_cnt,int noise_freq,int seed);
   void  build(bool staticMap=true);
   void  render() const;
   float getHeightOnTerrain(Vector3d *pos);
   float getHeightOnTerrain(Vector3d *pos,PlaneEqCache *cache);
   float getSlopeOnTerrain(Vector3d *pos);
   void  getPlaneOnTerrain(const Vector3d *pos,Vector3d *n,float *d);

protected:

   void setTextureCoord(float x, float z) const;
   void setFogCoord(float y) const;
   void renderTerrain() const;

   unsigned char *map;
   int   mapSize;
   int   stepSize;
   bool  staticMap;
   bool  fogEnabled;
   float fogDepth;
   Vector3d scale;
   Texture *texture;
   unsigned int dispListId;

   PlaneEqCache cache;

};






#endif