#include <lib3d/util2d/Particle.h>

Particle :: Particle(int maxPartCount) {
   
   this->maxPartCount = maxPartCount;
   setGravity(0.0f,-0.001f,0.0f);

   particles = new pEnt[maxPartCount];
   for (int i=0;i<maxPartCount;++i)
      particles[i].lifeTime = 0;

}

Particle :: ~Particle() {
   delete []particles;
}

void Particle :: setTexture(Texture *tex) {
   this->tex = tex;
}

void Particle :: setGravity(float x,float y,float z) {
   gravity.set(x,y,z);
}

Vector3d Particle :: getGravity() {
   return gravity;
}

void Particle :: setColor(float r,float g,float b) {
   color.r = r;
   color.g = g;
   color.b = b;
}

ColorVec Particle :: getColor() {
   return color;
}

void Particle :: setMaxSpeed(float maxs) {
   maxSpeed = maxs;
}

float Particle :: getMaxSpeed() {
   return maxSpeed;
}

void Particle :: setParameters(Vector3d center,Vector3d maxVel,Vector3d minVel,
                                     Vector3d maxAcc,Vector3d minAcc,float maxR) {
   this->center = center;
   this->maxAcc = maxAcc;
   this->minAcc = minAcc;
   this->maxVel = maxVel;
   this->minVel = minVel;
   this->maxRadius = maxR;
}

void Particle :: changeEntitiy(int e,Vector3d pos,Vector3d vel,Vector3d acc) {
   
   particles[e].acc = acc;
   particles[e].vel = vel;
   particles[e].pos = pos;
   particles[e].lifeTime = 1.0f;
   //particles[e].lifeTime = (rand()%10000) / 10000.0f;
      
}
   
void Particle :: addEntity(int index,Vector3d pos,Vector3d vel,Vector3d acc) {

   if (index != -1)
      changeEntitiy(index,pos,vel,acc);
   else   
      for (int i=0;i<maxPartCount;++i)
         if (particles[i].lifeTime <= 0.0f) {
            changeEntitiy(i,pos,vel,acc);
            return;
         }
}
   
void Particle :: addRandomEntity(Vector3d center,Vector3d maxVel,Vector3d minVel,Vector3d maxAcc,
                                      Vector3d minAcc,float maxPosRadius,int index) {
      
   Vector3d pos = center;
   pos.add(((rand()%10000) / 10000.0f)*maxPosRadius,
            ((rand()%10000) / 10000.0f)*maxPosRadius,
             ((rand()%10000) / 10000.0f)*maxPosRadius);
            
   Vector3d vel = minVel;
   vel.add(((rand()%10000) / 10000.0f)*(maxVel.x-minVel.x),
            ((rand()%10000) / 10000.0f)*(maxVel.y-minVel.y),
             ((rand()%10000) / 10000.0f)*(maxVel.z-minVel.z));
      
   Vector3d acc = minAcc;
   acc.add(((rand()%10000) / 10000.0f)*(maxAcc.x-minAcc.x),
            ((rand()%10000) / 10000.0f)*(maxAcc.y-minAcc.y),
             ((rand()%10000) / 10000.0f)*(maxAcc.z-minAcc.z));
     
   addEntity(index,pos,vel,acc);
 
}

void Particle :: addRandomEntities(int count,Vector3d center,Vector3d maxVel,Vector3d minVel,
                                          Vector3d maxAcc,Vector3d minAcc,float maxPosRadius) {
   while (count-- > 0) {
      addRandomEntity(center,maxVel,minVel,maxAcc,minAcc,maxPosRadius,-1);
   }

}
   
void Particle :: update(float dt) {

   for (int i=0;i<maxPartCount;++i)
             
      if (particles[i].lifeTime > 0.0f) {
         particles[i].pos.add(&particles[i].vel);
         particles[i].vel.add(&particles[i].acc);
         particles[i].vel.add(&gravity);
         particles[i].lifeTime -= dt;
      }
      else {
         addRandomEntity(center,maxVel,minVel,maxAcc,minAcc,maxRadius,i);
      }
         
}

void Particle :: render() {

   float modelview_mat[16];
   float rx,ry,rz,upx,upy,upz;

   glGetFloatv(GL_MODELVIEW_MATRIX,modelview_mat);

   rx = modelview_mat[0];
   ry = modelview_mat[4];
   rz = modelview_mat[8];
   float len = (float) sqrt((float)(rx*rx+ry*ry+rz*rz));
   rx /= len;
   ry /= len;
   rz /= len;
   upx = modelview_mat[1];
   upy = modelview_mat[5];
   upz = modelview_mat[9];
   len = (float) sqrt((float)(upx*upx+upy*upy+upz*upz));
   upx /= len;
   upy /= len;
   upz /= len;
      
   glPushAttrib(GL_ALL_ATTRIB_BITS);
   glEnable(GL_BLEND);
   glEnable(GL_DEPTH_TEST);
   glDepthMask(GL_FALSE);
   glDisable(GL_LIGHTING);
   glBlendFunc(GL_SRC_ALPHA,GL_ONE);
      
      
   float x,y,z;

   tex->begin();
      
   for (int i=0;i<maxPartCount;++i) {
      if (particles[i].lifeTime > 0) {

         x = particles[i].pos.x;
         y = particles[i].pos.y;
         z = particles[i].pos.z;
            
         glColor4f(color.r,color.g,color.b,particles[i].lifeTime);
            
         glBegin(GL_TRIANGLE_STRIP);
            tex->apply(1.0f, 1.0f); glVertex3f(x + (rx + upx), y + (ry + upy), z + (rz + upz));
            tex->apply(0.0f, 1.0f); glVertex3f(x + (upx - rx), y + (upy - ry), z + (upz - rz));
            tex->apply(1.0f, 0.0f); glVertex3f(x + (rx - upx), y + (ry - upy), z + (rz - upz));
            tex->apply(0.0f, 0.0f); glVertex3f(x + (-rx - upx), y + (-ry - upy), z + (-rz - upz));
         glEnd();
                  
      }
   }
   
   tex->end();

   glPopAttrib();
   //glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
   glDepthMask(GL_TRUE);
      
 
}