#include <lib3d/util2d/billboard.h>
#include <math.h>

Billboard :: Billboard() {
}

Billboard :: Billboard(Texture *tex) {
   texture = tex;
}

Billboard :: ~Billboard() {
   delete texture;
}

void Billboard :: setTexture(Texture *tex) {
   texture = tex;
}

void Billboard :: render() {

   glGetFloatv(GL_MODELVIEW_MATRIX,modelview_mat);

   rx = modelview_mat[0];
   
   // quake stili icin satir iptal edilmeli
   ry = modelview_mat[4];

   rz = modelview_mat[8];
   float len = (float) sqrt((float)(rx*rx+ry*ry+rz*rz));
   rx /= len;
   
   // quake stili icin satir iptal edilmeli
   ry /= len;

   rz /= len;
   
   // quake stili icin satir iptal edilmeli
   upx = modelview_mat[1];
   
   upy = modelview_mat[5];
   
   // quake stili icin satir iptal edilmeli
   upz = modelview_mat[9];
   
   len = (float) sqrt((float)(upx*upx+upy*upy+upz*upz));
   
   // quake stili icin satir iptal edilmeli
   upx /= len;
   
   upy /= len;
   
   // quake stili icin satir iptal edilmeli
   upz /= len;
         
   // quake stili icin asagidaki 3 satir uygulanmali
   //upx = 0.0f;
   //upz = 0.0f;
   //ry = 0.0f;
   //

   texture->begin();
   glBegin(GL_TRIANGLE_STRIP);
      texture->apply(0.0f, 0.0f); glVertex3f( (rx + upx),  (ry + upy),  (rz + upz));
      texture->apply(1.0f, 0.0f); glVertex3f( (upx - rx),  (upy - ry),  (upz - rz));
      texture->apply(0.0f, -1.0f); glVertex3f( (rx - upx),  (ry - upy),  (rz - upz));
      texture->apply(1.0f, -1.0f); glVertex3f( (-rx - upx),  (-ry - upy),  (-rz - upz));
   glEnd();
   texture->end();

      
}