#ifndef __COLLISIONDETECTOR_H__
#define __COLLISIONDETECTOR_H__

#include <lib3d/util3d/collision/vectormath.h>
#include <lib3d/model/modeltypes.h>
#include <lib3d/terrain/Terrain.h>

#define EPSILON 0.05f

struct tCollisionPacket {
 
   // data about player movement
   D3DVECTOR velocity;
   D3DVECTOR sourcePoint;
  
   // radius of ellipsoid.  
   D3DVECTOR eRadius ;
  
   // for error handling  
   D3DVECTOR lastSafePosition;
   BOOL stuck; 
    
   // data for collision response 
   BOOL foundCollision;
   double    nearestDistance; // nearest distance to hit
   D3DVECTOR nearestIntersectionPoint; // on sphere
   D3DVECTOR nearestPolygonIntersectionPoint; // on polygon
};

class CollisionDetector {

public:

   CollisionDetector()  {};
   ~CollisionDetector() {};

   D3DVECTOR getPosition(tMesh *mesh,D3DVECTOR position, D3DVECTOR velocity);
   D3DVECTOR getPositionOnTerrain(Terrain *t,D3DVECTOR position, D3DVECTOR velocity);
      
private:
   
   D3DVECTOR collideWithWorld(tMesh *mesh,D3DVECTOR position, D3DVECTOR velocity);
   void      checkCollision(tMesh *mesh,tCollisionPacket* colPackage);


};




#endif