#include <lib3d/model/animatedModel.h>

AnimatedModel :: AnimatedModel() {
   time = 0;
   anims = NULL;
   animCount = 0;
   activeAnimation(0);
   setSpeed(3);
   setLooping(true);
   setStopped(false);
}

AnimatedModel :: AnimatedModel(Model *model) {
   
   this->anims = NULL;
   
   tAnimation *anim = new tAnimation;
   anim->firstFrame = 0;
   anim->lastFrame = 0;
   anim->currDestFrame = 0;
   anim->currSourceFrame = 0;
   strcat(anim->name,"");
   setAnimations(anim,1);
   activeAnimation(0);
   setSpeed(3);
   time = 0;
   setStopped(false);
   setLooping(false);

   setMeshes(model->meshes,model->meshCount);
   setMaterials(model->materials,model->materialCount);
   setPath(model->getPath());
   //meshes[0].materialIndex = 0;   //HACK!

}

AnimatedModel :: ~AnimatedModel() {

   for (int i=1;i<meshCount;++i) {
      meshes[i].faces = NULL;
      meshes[i].uvs = NULL;
   }

   delete []anims;

   // Model sinifinini destructor fonksiyonu
   // geri kalan temizleme islemlerini halledecektir..
   // mesh[0] haricindeki diger mesh lerin face ve uvs pointerlari
   // mesh[0].faces ve mesh[0].uvs i gosterdikleri icin onlari burada
   // temizlemiyoruz.. model sinifi bu isi halledicek.. :D

}

void AnimatedModel :: activeAnimation(int animNum) {
   if (animNum <= animCount)
      activeAnim = animNum;
}

int AnimatedModel :: getActiveAnimation() const {
   return activeAnim;
}

int AnimatedModel :: getAnimationCount() const {
   return animCount;
}

int AnimatedModel :: getCurrentSourceMeshIndex() const {
   return anims[activeAnim].currSourceFrame;
}

int AnimatedModel :: getCurrentDestMeshIndex() const {
   return anims[activeAnim].currDestFrame;
}

Vector3d AnimatedModel :: getBoundingBox() {

   Vector3d bbvec;
   Vector3d bbvec1 = Model::getBoundingBox(anims[activeAnim].currSourceFrame);
   Vector3d bbvec2 = Model::getBoundingBox(anims[activeAnim].currDestFrame);
   
   bbvec.set(&bbvec1);
   bbvec.add((bbvec2.x-bbvec1.x)*anim_dt,(bbvec2.y-bbvec1.y)*anim_dt,(bbvec2.z-bbvec1.z)*anim_dt);
            
   return bbvec;
}

float AnimatedModel :: getBoundingSphere() {

   float rad1 = Model::getBoundingSphere(anims[activeAnim].currSourceFrame);
   float rad2 = Model::getBoundingSphere(anims[activeAnim].currDestFrame);

   return (rad1 + ((rad2 - rad1) * anim_dt));
}

void AnimatedModel :: setLooping(bool b) {
   looped = b;
}

void AnimatedModel :: setStopped(bool b) {
   stopped = b;
}

void AnimatedModel :: setSpeed(float fac) {
   animSpeedFactor = fac;
}


void AnimatedModel :: animate(float dt) {

   if (stopped)
      return;
   
   tAnimation &anim = anims[activeAnim];
   
   time += dt;
   anim_dt = time * animSpeedFactor;
   
   if (time >= (1.0f / animSpeedFactor)) {
      ++anim.currSourceFrame;
      ++anim.currDestFrame;
      if (anim.currSourceFrame >= anim.lastFrame) {
         if (anim.currSourceFrame > anim.lastFrame)
            anim.currSourceFrame = anim.firstFrame;
         else {
            if (looped) {
               anim.currDestFrame = anim.firstFrame;
            }
            else
               setStopped(true);
         }
      }

      anim_dt = 0;
      time = 0;

   }

}            

void AnimatedModel :: render() {

   Texture *texture;
   if (materials != NULL && materialCount > meshes[anims[activeAnim].currSourceFrame].materialIndex)
      texture = materials[meshes[anims[activeAnim].currSourceFrame].materialIndex].texture;
   
   if (texture)
      render_textured(texture);
   else
      render_untextured();

}

void AnimatedModel :: render_textured(Texture *texture) const {

   tAnimation *a = &anims[activeAnim];
   
   tMesh *smesh = &meshes[a->currSourceFrame];
   tMesh *dmesh = &meshes[a->currDestFrame];

   texture->begin();

   Vector3d difVec;
   
   for (int f=0;f<smesh->faceCount;++f) {
      glBegin(GL_TRIANGLES);
      tFace *ff = &smesh->faces[f];
      for (int i=0;i<3;++i) {
         
         /*
         glNormal3f(mesh.normals[ff->n[i]].x,
                    mesh.normals[ff->n[i]].y,
                    mesh.normals[ff->n[i]].z);
         */

         texture->apply(smesh->uvs[ff->uv[i]].u,smesh->uvs[ff->uv[i]].v);
         
         difVec.set(dmesh->vertices[ff->v[i]].x - smesh->vertices[ff->v[i]].x,
                    dmesh->vertices[ff->v[i]].y - smesh->vertices[ff->v[i]].y,
                    dmesh->vertices[ff->v[i]].z - smesh->vertices[ff->v[i]].z);

         
         glVertex3f(smesh->vertices[ff->v[i]].x + difVec.x * anim_dt,
                    smesh->vertices[ff->v[i]].y + difVec.y * anim_dt,
                    smesh->vertices[ff->v[i]].z + difVec.z * anim_dt);


      }
      glEnd();
   }

   texture->end();

}

void AnimatedModel :: render_untextured() const {

   tAnimation *a = &anims[activeAnim];
   
   tMesh *smesh = &meshes[a->currSourceFrame];
   tMesh *dmesh = &meshes[a->currDestFrame];

   Vector3d difVec;
   
   for (int f=0;f<smesh->faceCount;++f) {
      glBegin(GL_TRIANGLES);
      tFace *ff = &smesh->faces[f];
      for (int i=0;i<3;++i) {
         /*
         glNormal3f(mesh.normals[ff->n[i]].x,
                    mesh.normals[ff->n[i]].y,
                    mesh.normals[ff->n[i]].z);
         */
         
         difVec.set(dmesh->vertices[ff->v[i]].x - smesh->vertices[ff->v[i]].x,
                    dmesh->vertices[ff->v[i]].y - smesh->vertices[ff->v[i]].y,
                    dmesh->vertices[ff->v[i]].z - smesh->vertices[ff->v[i]].z);

         glVertex3f(smesh->vertices[ff->v[i]].x + difVec.x * anim_dt,
                    smesh->vertices[ff->v[i]].y + difVec.y * anim_dt,
                    smesh->vertices[ff->v[i]].z + difVec.z * anim_dt);


      }
      glEnd();
   }

}

void AnimatedModel :: setAnimations(tAnimation *anims,int animCount) {

   if (this->anims)
      delete[] this->anims;

   this->anims = anims;
   this->animCount = animCount;
}

