#include <lib3d/util3d/bezierpath.h>

BezierPath :: BezierPath() {
   setDensity(10);
}

BezierPath :: BezierPath(Vector3d p0,Vector3d p1,Vector3d p2,Vector3d p3) {
   setControlPoints(p0,p1,p2,p3);
}

BezierPath :: ~BezierPath() {
}

void BezierPath :: setControlPoints(Vector3d p0,Vector3d p1,Vector3d p2,Vector3d p3) {
   cpoints[0] = p0;
   cpoints[1] = p1;
   cpoints[2] = p2;
   cpoints[3] = p3;
}

void BezierPath :: setControlPoint(Vector3d p,int pnum) {
   if (pnum < 4 && pnum >= 0)
      cpoints[pnum] = p;
}

void BezierPath :: setDensity(int d) {
   density = d;
}

int BezierPath :: getDensity() {
   return density;
}

void BezierPath :: calculate() {

   float t,var1,var2,var3;
   Vector3d p;
   
   pointVector.clear();
   for (int i=0;i<density-1;++i) {
      t = (float)i / density; 
      var1 = 1 - t;
      var2 = var1 * var1 *var1;
      var3 = t * t * t;
      p.x = var2*cpoints[0].x + 3*t*var1*var1*cpoints[1].x + 3*t*t*var1*cpoints[2].x + var3*cpoints[3].x;
      p.y = var2*cpoints[0].y + 3*t*var1*var1*cpoints[1].y + 3*t*t*var1*cpoints[2].y + var3*cpoints[3].y;
      p.z = var2*cpoints[0].z + 3*t*var1*var1*cpoints[1].z + 3*t*t*var1*cpoints[2].z + var3*cpoints[3].z;
      pointVector.push_back(p);
   }
   pointVector.push_back(cpoints[3]);

}

void BezierPath :: getPointOnCurve(Vector3d *p,int pnum) {
   p->set(&pointVector[pnum]);
}

void BezierPath :: getAllPointsOnCurve(Vector3d *p[]) {
   
   int i=0;
   vector<Vector3d>::iterator vi = pointVector.begin();

   while (vi != pointVector.end()) {
      p[i++]->set(vi);
      ++vi;
   }
   
}
