#include <lib3d/util3d/position3d.h>

#include <math.h>
#define  M_PI   3.14159265358979323846

Position3d :: Position3d() {
}
	
Position3d :: Position3d(Vector3d *pos,float xa,float ya,float za) {
   this->pos = *pos->clone();
   xangle = xa;
   yangle = ya;
   zangle = za;
}
	
Position3d :: ~Position3d() {
}

void Position3d :: set(const Position3d *pos3d) {
   this->pos.set(&pos3d->pos);
   this->xangle = pos3d->xangle;
   this->yangle = pos3d->yangle;
   this->zangle = pos3d->zangle;
}

Vector3d* Position3d :: getDirection() const {
	         
   float x = -(float) sin(yangle*M_PI/180);
   float z = -(float) cos(yangle*M_PI/180);
   Vector3d *direction = new Vector3d(x,0.0f,z);
   direction->normalize();      
            
   return direction;
}
	
void Position3d :: turnLeft(float angle) {
   yangle += angle;
}
			
void Position3d :: turnRight(float angle) {
   yangle -= angle;
}
   
void Position3d :: turnUp(float angle) {
   xangle -= angle;
}
			
void Position3d :: turnDown(float angle) {
   xangle += angle;
}
	
void Position3d :: strafeLeft(float dist) {
   pos.x -= (float) sin((yangle+90.0f)*M_PI/180) * dist;
   pos.z -= (float) cos((yangle+90.0f)*M_PI/180) * dist;
}
			
void Position3d :: strafeRight(float dist) {
   pos.x += (float) sin((yangle+90.0f)*M_PI/180) * dist;
   pos.z += (float) cos((yangle+90.0f)*M_PI/180) * dist;
}

void Position3d :: moveUp(float dist) {
   pos.y += dist;
}

void Position3d :: moveDown(float dist) {
   pos.y -= dist;
}
	
void Position3d :: moveForward(float dist) {
   pos.x -= (float) sin(yangle*M_PI/180) * dist;
   pos.z -= (float) cos(yangle*M_PI/180) * dist;
}

void Position3d :: moveBackward(float dist) {
   pos.x += (float) sin(yangle*M_PI/180) * dist;
   pos.z += (float) cos(yangle*M_PI/180) * dist;
}

Position3d Position3d :: clone() const {
   
   Position3d p;
   p.pos.set(&pos);
   p.xangle = xangle;
   p.yangle = yangle;
   p.zangle = zangle;

   return p;
}
