/////////////////////////////////////////////////////////////////////////////////////
// Yazdigimiz programlarda,demolarda her zaman kutular,dikdrtgenler kullanamayz.
// Artk ekrana model karma zaman geldi diyorsanz bu yazi tam sizler iin.
// Bu kodu anladktan sonra artk dier model formatlarini kullanmak ok kolay!
// Bir nceki "Ktk ilemleri" adl yazda metin dosyalarndan bahsetmitik
// imdi o bilgileri kullanarak bir Obj dosyayi yklemeyi inceliyeceiz
// Basit bir model dosyasi(sadece vertex koordinatlari ve ucgen(face,triangle)lerin vertex 
// indeksleri olsun) u ekilde olabilir: 

// Dosyada nce vertexler  bileeniyle(x,y,z) verilebilir.Ornek olarak;

// numVertices : 6
// 1.0 3.0 4.0
// 2.0 1.0 4.0
// 5.0 6.0 4.5
// 0.4 2.0 2.0
// 3.2 0.4 1.0
// 3.4 2.5 8.5

// 6 adet vertex'imiz var. Peki ama bunlardan nasl,hangi genler oluacak.
// Bunu zmek iin vertex indeksleri kullanlr.Dosyada indekslerimiz u ekilde  olsun;
 
// numFaces 4
// 0 2 3
// 4 5 1
// 5 3 0
// 1 4 2

// Hepsinden once dosyada kac vertex,ucgen vs varsa bunlar iin nce bellekte dinamik olarak
// yer ayrmalyz.(new,malloc).Isteyenler STL(standart template library) den <vector> kullanabilir.

// Burada 4 gen var. Peki bu rakamlar neyi ifade ediyor.
// 0 2 3 -> bu rakamlar, 1.ucgenin yukarda belirttiimiz vertexlerden 0. 2. ve 3. vertexi
// kullanacan belirtiyor.
// 2.ucgen 4. 5. ve 1. vertexleri kullanacak vs..
// Ucgen dizimiz face[ucgensayisi][3] 3 sayisi genin  kesi olduu iin
// vertex dizimiz vert[vertexsayisi] olsun.Birinci(face[0]) ucgeni cizmek icin;
// index1=face[0][0]; index2=face[0][1]; index3=face[0][2];
// index degiskenleri srasyla yukarda bahsettiimiz 0 2 3 degerlerini ald.
// glVertex3f(vert[index1].x,vert[index1].y,vert[index1].z);
// glVertex3f(vert[index2].x,vert[index2].y,vert[index2].z);
// glVertex3f(vert[index3].x,vert[index3].y,vert[index3].z);
// Tum model dosyalari bu ve buna benzer yntemlerle alr.

// Obj dosyalarina gelirsek.Obj dosyalari ok basit text dosyalardir.
// ou model programlar obj dosyasn export/import edebilir.Ama ou kendine gre
// dosyaya eklemeler,karmalar yapyor.Bazs normal vektorlerini yazar,
// grup isimlerini ekler,bazsnda bu opsiyoneldir vs.ndireceiniz *.obj(MilkShape3D'de
// kaydedilmidir www.milkshape3d.com) dosyasini ap incelerseniz 
// v,vt,vn,f ile balayan satrlar greceksiniz.
// Diger satrlar gzard edebiliriz.
// Dosyada:
// 'v' ile balayan satrlar vertexi belirtir ve sonraki 3 sayi vertexin x,y,z bileenleridir
// 'vt' doku kordinatlarn(Texture Coordinates) sonraki 2 sayi u,v bileenleridir.
// 'vn' vertex normallerini belirtir.3 sayi x,y,z bileenleridir.
// 'f' ise yukarida anlattiimim ucgenlerin vertex,normal,doku kordinatlar indeksleri iindir.
// Dikkat ettiyseniz 9 deger var
// f v1/vt1/vn1 v2/vt2/vn2 v3/vt3/vn3
// v1/vt1/vn1 genin 1. kesinin vertex,normal,doku kordinat indeksi dierleri 2.3.keler
// Bu ucgenin sadece hangi vertexlerden olutuu deil buna ek olarak hangi doku 
// koordinatlari(vt),ve hangi normalleri(vn) kullandn da anlatyor bu satr.
// Kullanacamz tipler ve basit obj snf u ekilde
// Doku kordinatlarn saklamak iin kullanacaz.


#include "obj.h"


// CObj model snfmzdan bir nesne yaratalim
CObj g_ObjModel;

// Modelimizi y ekseni etrafnda dndrrken bu degiskeni kullanacaz
float rot=0.0;

// Klasik opengl arlarn(glDepthFunc,glClearColor..vs iin) bu fonksiyonda topladm
void InitGL();

// lk alta ve grnt yeniden boyutlandrldnda arlan ReSize
void ReSize(int w, int h) {

	if(h == 0)
		h = 1;
	
	float ratio = 1.0* w / h;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	
    glViewport(0, 0, w, h);

	gluPerspective(70,ratio,1,1000);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
		
}

// izim fonksiyonumuz

void RenderScene(void) 
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);// tampon bellei temizle
	glLoadIdentity();// identity matriksi ykle
	gluLookAt(0,0,50,0,0,49,0,1,0); // kameray ayarla 
	glCullFace(GL_BACK); // gizli yzeylerimiz arka yzeyler
	glEnable(GL_CULL_FACE); // bu yzeyleri izmiyoruz
	glRotatef(rot,0.0,1.0f,0.0);
	glTranslatef(0.0,0.0,25);
	g_ObjModel.Render();    // modelimizi iziyoruz
	glutSwapBuffers();		// tampon bellei ekrana kart
	rot+=0.3;
	
}
void Keys(unsigned char key, int x, int y) {

	switch (key) {
	
			// 27 = > ESC'ye baslrsa program kapatyoruz 
			case 27 :
				g_ObjModel.Destroy();
				exit(0);
				break;
			// 'l' standart opengl mz ayor 'k' kapatyor
			case 'l':
				glDisable(GL_LIGHTING);
				break;
		
			case 'k':
				glEnable(GL_LIGHTING);
				break;
		}
	

}

void main(int argc, char **argv) {
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DEPTH | GLUT_DOUBLE | GLUT_RGBA);
	glutInitWindowSize(800,600);
	glutCreateWindow("Wavefront OBJ");
	glutFullScreen();
	// Burada modelimizi yklyoruz
	g_ObjModel.LoadObj("clay.obj");
	InitGL();
	glutKeyboardFunc(Keys);
	glutDisplayFunc(RenderScene);
	glutIdleFunc(RenderScene);
	glutReshapeFunc(ReSize);
	glutMainLoop();
}
void InitGL()
{
	glEnable(GL_TEXTURE_2D);
	glShadeModel(GL_SMOOTH);
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	glClearDepth(1.0f);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	// Standart deerleriyle bir k ekliyoruz.
	glEnable(GL_LIGHT0);
	// I ayoruz
	glEnable(GL_LIGHTING);
	// I anca renklerin grnmesine izin veriyoruz.
	glEnable(GL_COLOR_MATERIAL);
}
