#include "obj.h"
#include "main.h"
#include "conio.h"

// Dokuyu kullanabilmek iin bu deikeni tanmlyoruz.
unsigned int texture;

void getStr(FILE *f,char *satir,char c);
void LoadTexture(unsigned int &texture,const char *dosya);


CObj::CObj()
{
	m_numVerts		= 0;
	m_numTexCoords	= 0;
	m_numNormals	= 0;
	m_numFaces		= 0;
	
	m_pVerts	= NULL;
	m_pTexCoords= NULL;
	m_pNormals	= NULL;
	m_pFaces	= NULL;
}

// Bu fonksiyon dosyadaki her satr okuyup satrn ilk karakterine gore dosyada kac tane
// vertex,normal,ucgen,doku koordinati oldugunu buluyor ve ye deikenlere atyor.

void CObj::GetNums(FILE *fp)
{
	char satir[255];

	while(!feof(fp))
	{
		fgets(satir,255,fp);
		// vertex mi?
		if((satir[0]=='v') && (satir[1]==' '))
		{
			m_numVerts++;
		}
		// doku kordinatm ?
		else if((satir[0]=='v') && (satir[1]=='t'))
		{
			m_numTexCoords++;
		}
		// normal mi?
		else if((satir[0]=='v') && (satir[1]=='n'))
		{
			m_numNormals++;
		}
		// ucgen mi?
		else if(satir[0]=='f')
		{
			m_numFaces++;
			
		}
		// Ne olur ne olmaz satir degiskenimizi sfrlayalm.
		memset (satir, '\0', sizeof (satir));

	}
	
	// Dosyayi tekrar kullanacamz iin baa saryoruz.Kaset gibi.
	rewind(fp);

	// Bulduumuz sayilara gre bellekte yer ayryoruz.
	// pointerdegisken = new yap [sayi*sizeof(yap)] eklinde yapyoruz.

	m_pVerts	= new Vektor3	[m_numVerts*sizeof(Vektor3)];
	m_pNormals	= new Vektor3	[m_numNormals*sizeof(Vektor3)];
	m_pTexCoords= new Vektor2	[m_numTexCoords*sizeof(Vektor2)];
	m_pFaces	= new OBJ_Face	[m_numFaces*sizeof(OBJ_Face)];

}
void CObj::LoadObj(const char *dosya)
{
	FILE *fp;
	
	// Dosyadan okunacak her satr bu degiskende
	char satir[255];
		
	fp = fopen(dosya,"rt");
	
	if(fp==NULL){
		printf("\n%s acilamadi!\n",dosya);
		exit(0);
	}
	
	// vertex,normal vs.. saysn ogrenip bellekte yer ayryoruz GetNums() ile.
	GetNums(fp);
    // getStr() fonksiyonu 3.parametresinde	verilen karakterle balyan satr okumak iin
	// Bunun amac:rnein v satrlar arasnda bosluk, yorum satr veya ilgilenmediimiz bir
	// satr varsa onu atlamak.
	// v 1.0 2.0 2.0
    // # exported by... 
	// v 3.0 2.0 4.0
	// gibi..burada # ile baslyan satrla ilgilenmiyoruz.
	// Dosyann basndan itibaren sayisi kadar vertexleri okuyoruz
	for(int i=0;i<m_numVerts;i++)
	{
		getStr(fp,satir,'v');
		sscanf(satir,"v %f %f %f",&m_pVerts[i].x,&m_pVerts[i].y,&m_pVerts[i].z);
	}
	// Doku koordinatlar
	for(i=0;i<m_numTexCoords;i++)
	{
		getStr(fp,satir,'v');
		sscanf(satir,"vt %f %f",&m_pTexCoords[i].u,&m_pTexCoords[i].v);
	}
	// Normaller
	for(i=0;i<m_numNormals;i++)
	{
		getStr(fp,satir,'v');
		sscanf(satir,"vn %f %f %f",&m_pNormals[i].x,&m_pNormals[i].y,&m_pNormals[i].z);
	}
	
	// Kodu ksaltmak iin gecici fc degiskenini tanmladk ve sfrladk
	OBJ_Face fc={0};
	
	// ucgen bilgisi okunuyor.
	for(i=0;i<m_numFaces;i++)
	{
		
		getStr(fp,satir,'f');
		sscanf(satir,"f %d/%d/%d %d/%d/%d %d/%d/%d",&fc.vertexIndex[0],&fc.textureIndex[0],&fc.normalIndex[0],
													&fc.vertexIndex[1],&fc.textureIndex[1],&fc.normalIndex[1],
													&fc.vertexIndex[2],&fc.textureIndex[2],&fc.normalIndex[2]
													);
		m_pFaces[i]=fc;
	}
	// Belki gereksiz ama ekrana da vertex,normal,doku kordinat,ucgen saymz yazalm.
	// Kontrol etmi oluruz.
	printf("Dosya : %s\n\n",dosya);
	printf("Vertex Sayisi		: %d\n",m_numVerts);
	printf("Normal Sayisi		: %d\n",m_numNormals);
	printf("Doku Kordinati Sayisi   : %d\n",m_numTexCoords);
	printf("Ucgen Sayisi		: %d\n\n",m_numFaces);
	
	// Dokumuzu yukluyoruz.
	LoadTexture(texture,"claymore.bmp");
	// Dosyay da kapattk.
	fclose(fp);
	
}
void CObj::Render()
{
	// modelimizi cizmek iin yapmamz gereken artk cok basit.2 dng iimizi gryor.
	// 1.si 0 dan m_numFaces'e kadar bir dng yani tm ucgenleri cagiracagiz
	// 2.si ise bir genin  kesi olduu iin 0 dan 2 ye kadar bir dng
	
	// en iteki for dngsnde o anki ucgenin v,vn,vt indeksleri bu degiskenlerde saklanacak
	// Yine kodu ksaltmak iin tanmlyoruz
	int i_v,i_vn,i_vt;

	// indeksimizi aldktan sonra vertex,normal,vs.. dizimizden ilgili vertex,normal,doku kor
	// dinatinin baslangic adresini bu iaretilerde saklyoruz ki.Bunlar glVertex,glNormal
	// glTexCoord'a parametre olarak gecirelim.Bunu da kodu fazla kartrmamak iin yapyoruz.
	
	Vektor3 *vV,*vN;
	Vektor2 *vT;

	// Dokumuzu seciyoruz.
	glBindTexture(GL_TEXTURE_2D, texture);			
	
	glBegin(GL_TRIANGLES);
	
		for(int i=0;i <m_numFaces;i++)
		{	
			for(int j=0;j<3;j++)
			{
				// ilgili ucgenin ilgili bileeninin indeksini alyoruz.
				i_v		= m_pFaces[i].vertexIndex[j];
				i_vn	= m_pFaces[i].normalIndex[j];
				i_vt	= m_pFaces[i].textureIndex[j];
				
				// bu indeksler vastasyla ilgili vertexi,normali.vs buluyoruz.
				// Burada indekslerden 1 karmamzn nedeni Obj dosyasinda
				// rnein f 1/1/2 2/3/1 3/1/2  // Hi sfr yok
				// burada ucgenin ilk vertexinin indeksi 1 ama biz biliyoruz ki 
				// kastetdii vertex m_pVerts[1] deil m_pVerts[0]
				// Dolaysyla 1 eksiltiyoruz.

				vV = &m_pVerts[i_v-1];
				vN = &m_pNormals[i_vn-1];
				vT = &m_pTexCoords[i_vt-1];

				// Son olarak da bunlar opengl'ye gonderiyoruz.
				glNormal3f(vN->x,vN->y,vN->z);
				glTexCoord2f(vT->u,vT->v);
				glVertex3f(vV->x,vV->y,vV->z);
			}
	
		}

	glEnd();
	
}
void CObj::Destroy()
{

	// Bellekte ayrdmz yerleri geri iade etmek gerekiyor.
	if(m_pVerts) 
	{
		delete [] m_pVerts;
		m_pVerts = NULL;
	}
	
	if(m_pNormals) 
	{
		delete [] m_pNormals;
		m_pNormals = NULL;
	}
	
	if(m_pTexCoords) 
	{
		delete [] m_pTexCoords;
		m_pTexCoords = NULL;
	}

	if(m_pFaces)	
	{
		delete [] m_pFaces;
		m_pFaces = NULL;
	}


}
CObj::~CObj()
{
	Destroy();
}

void getStr(FILE *f,char *satir,char kr)
{
	// Grdnz gibi okuduu satrn ilk karakteri parametredeki kr'ye eit oluncaya kadar 
	// kadar okuma yapyor.Karlanca dngden kyor.Bu ekilde dosyada ki boluklardan,
	// gereksiz bilgilerden, yorum satrlarndan..vs kurtuluyoruz.

	do
	{
		fgets(satir, 255, f);
	} while (satir[0] != kr);
			 
	return;
}
// Dokular ykleyebilmemiz iin gereken fonksiyon
void LoadTexture(unsigned int &texture,const char *dosya)
{
	AUX_RGBImageRec *pBitmap = NULL;
	
	if(!dosya)
		return;
	
	pBitmap = auxDIBImageLoad(dosya);
	
	if(pBitmap == NULL)
		exit(0);

	glGenTextures(1, &texture);

	glBindTexture(GL_TEXTURE_2D, texture);
		
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR_MIPMAP_NEAREST);
	gluBuild2DMipmaps(GL_TEXTURE_2D,GL_RGB8, pBitmap->sizeX, pBitmap->sizeY, GL_RGB, GL_UNSIGNED_BYTE, pBitmap->data);

	if (pBitmap)
	{
		if (pBitmap->data)
		{
			free(pBitmap->data);
		}

		free(pBitmap);
	}
}



	