#include "tunel.h"

#include <math.h>
#include <malloc.h>
#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>

// Bo tnel
int	CreateEmptyTunnel( tunnel_t *tunnel, int nRing, int nVertex, float radius, float w )
{
	int				i;
	struct ring_t	*ring;

	tunnel->ringLump	= (ring_t *)malloc(sizeof(ring_t)*nRing);

	tunnel->numRing		= nRing;
	tunnel->numVertex	= nVertex;
	tunnel->width		= w;

	static int aa=0, bb=0, b=0, a;

	for ( i=0; i<nRing; i++ )
	{
		ring = &tunnel->ringLump[i];

		ring->radius	= radius;

		ring->xangle	= 0;
		ring->yangle	= 0;
		
		ring->tmat[0]	= 1.0f;	ring->tmat[1]	= 0.0f;	ring->tmat[2]	= 0.0f;
		ring->tmat[3]	= 0.0f;	ring->tmat[4]	= 1.0f;	ring->tmat[5]	= 0.0f;
		ring->tmat[6]	= 0.0f;	ring->tmat[7]	= 0.0f;	ring->tmat[8]	= 1.0f;

		tunnel->ringLump[i].vertexLump		= (vec3_t *)malloc(sizeof(vec3_t)*nVertex);
		tunnel->ringLump[i].normalLump		= (vec3_t *)malloc(sizeof(vec3_t)*nVertex);
		tunnel->ringLump[i].texcoordLump	= (vec2_t *)malloc(sizeof(vec2_t)*(nVertex+1));
	}

	return 0;
}

//
void tApply_1X( tunnel_t *tunnel, int start, int end, int wsize )
{
	int		i;
	float	xc, sign;

	xc = 0;
	sign = 1;
	for ( i=start; i<=end; i++ )
	{
		xc++;
		if ( xc == wsize )
		{
			xc = 0;
			sign *= -1;
		}

		if ( sign==1 )
			tunnel->ringLump[i].xangle = tunnel->ringLump[i-1].xangle + 1;
		else
			tunnel->ringLump[i].xangle = tunnel->ringLump[i-1].xangle - 1;
	}
}

// 
void tApply_1Y( tunnel_t *tunnel, int start, int end, int wsize )
{
	int		i;
	float	xc, sign;

	xc = 0;
	sign = 1;
	for ( i=start; i<=end; i++ )
	{
		xc++;
		if ( xc == wsize )
		{
			xc = 0;
			sign *= -1;
		}

		if ( sign==1 )
			tunnel->ringLump[i].yangle = tunnel->ringLump[i-1].yangle + 1;
		else
			tunnel->ringLump[i].yangle = tunnel->ringLump[i-1].yangle - 1;
	}
}

// Her halkann merkezi ve btn vertexleri hesaplanr
void CompileTunnel( tunnel_t *tunnel )
{
	int				i, i2;
	float			ud, d;
	struct ring_t	*ring, *ringL;
	float			rad, radx, rady;
	vec3_t			vTmp;

	// Halka matrisleri belirlenmi alarna gre dndrlr ve t matrisleri bulunur
	for ( i=0; i<tunnel->numRing; i++ )
	{
		ring	= &tunnel->ringLump[i];

		radx	= PI_BOL_180 * ring->xangle;
		rady	= PI_BOL_180 * ring->yangle;

		ring->tmat[0] = cosf(rady);				ring->tmat[1] = 0.0f;		ring->tmat[2] = sinf( rady );
		ring->tmat[3] = sinf(radx)*sinf(rady);	ring->tmat[4] = cosf(radx);	ring->tmat[5] = -sinf(radx)*cosf(rady);
		ring->tmat[6] = -cosf(radx)*sinf(rady);	ring->tmat[7] = sinf(radx);	ring->tmat[8] = cosf(radx)*cosf(rady);
	}

	// matris, width ve center deerleri ile sonraki halkann merkezi hesaplanr
	// lk halkann merkezi (0, 0, 0) dr.
	tunnel->ringLump[0].center[0] = 0.0f;
	tunnel->ringLump[0].center[1] = 0.0f;
	tunnel->ringLump[0].center[2] = 0.0f;
	for ( i=1; i<tunnel->numRing; i++ )
	{
		ring = &tunnel->ringLump[i];
		ringL = &tunnel->ringLump[i-1];

		ring->center[0] = ringL->center[0] + ringL->tmat[2] * tunnel->width;
		ring->center[1] = ringL->center[1] + ringL->tmat[5] * tunnel->width;
		ring->center[2] = ringL->center[2] + ringL->tmat[8] * tunnel->width;
	}

	// Yine bu matris yardmyla halkann kenar(ke) vertexleri hesaplanr
	for ( i=0; i<tunnel->numRing; i++ )
	{
		ring = &tunnel->ringLump[i];
		ud = 360.0f / tunnel->numVertex;

		for ( i2=0; i2<tunnel->numVertex; i2++ )
		{
			// Halkann transform matrisinin x/y dzlemi zerindeki kenar vertexleri hesaplanr
			// Dikkat:aadaki sin cos ler daire hesaplanmasndan geliyor!!!
			rad = ud*i2*PI_BOL_180;

			ring->vertexLump[i2][0]	=	ring->tmat[0]*cosf( rad ) + 
										ring->tmat[1]*sinf( rad );

			ring->vertexLump[i2][1]	=	ring->tmat[3]*cosf( rad ) + 
										ring->tmat[4]*sinf( rad );

			ring->vertexLump[i2][2]	=	ring->tmat[6]*cosf( rad ) + 
										ring->tmat[7]*sinf( rad );


			ring->vertexLump[i2][0] *= ring->radius;
			ring->vertexLump[i2][1] *= ring->radius;
			ring->vertexLump[i2][2] *= ring->radius;

			// Normalleri hesaplanr
			vTmp[0] = ring->vertexLump[i2][0];
			vTmp[1] = ring->vertexLump[i2][1];
			vTmp[2] = ring->vertexLump[i2][2];

			// Normalize
			d = sqrtf( vTmp[0]*vTmp[0] + vTmp[1]*vTmp[1] + vTmp[2]*vTmp[2] );
			vTmp[0] *= 1.0f/d;
			vTmp[1] *= 1.0f/d;
			vTmp[2] *= 1.0f/d;
			
			ring->normalLump[i2][0] = -vTmp[0];
			ring->normalLump[i2][1] = -vTmp[1];
			ring->normalLump[i2][2] = -vTmp[2];

			// Kendi merkezine tanr ( nceki admda hesaplanmt )
			ring->vertexLump[i2][0]	+= ring->center[0];
			ring->vertexLump[i2][1]	+= ring->center[1];
			ring->vertexLump[i2][2]	+= ring->center[2];
		}
	}
}

//
void tMakeTexture( tunnel_t *tunnel, int texID, int sRing, int eRing, float uScale, float vScale )
{
	int				i, i2;
	struct ring_t	*ring;

	for ( i = sRing; i <= eRing; i++ )
	{
		for ( i2 = 0; i2 < tunnel->numVertex; i2++ )
		{
			ring = &tunnel->ringLump[i];

			ring->texcoordLump[i2][0] = ( (float)i2 / (float)(tunnel->numVertex) )*uScale;
			ring->texcoordLump[i2][1] = (i%2)*vScale;
		}
		ring->texcoordLump[tunnel->numVertex][0] = uScale;
		ring->texcoordLump[tunnel->numVertex][1] = (i%2) * vScale;

		ring->texID = texID;
	}
}

// nRing = {0, 1, ...., nRing-2}
void RenderTunnel( tunnel_t tunnel, int nRing, int numRing, float dist, float tX, float tY )
{
	int				i, i2;
	struct ring_t	*ring, *ringN, *ringL;
	int				toRing;
	float			lpos[4];
	unsigned int	tID;

	vec3_t			ttX, ttY;
	vec3_t			eye, center;

	//
	while ( dist >= tunnel.width )
	{
		dist -= tunnel.width;
		nRing++;
		if ( nRing >= (tunnel.numRing-2) )
			return;
	}

	// 
	toRing = nRing + numRing;
	if ( toRing >= (tunnel.numRing-1) )
		toRing = tunnel.numRing - 1;

	ring = &tunnel.ringLump[ nRing ];		// ring
	ringN = &tunnel.ringLump[ nRing+1 ];	// ring next
	ringL = &tunnel.ringLump[ toRing ];		// ring last

	eye[0] = ring->center[0] + ring->tmat[2] * dist;
	eye[1] = ring->center[1] + ring->tmat[5] * dist;
	eye[2] = ring->center[2] + ring->tmat[8] * dist;

	center[0] = ringN->center[0] + ringN->tmat[2] * dist;
	center[1] = ringN->center[1] + ringN->tmat[5] * dist;
	center[2] = ringN->center[2] + ringN->tmat[8] * dist;

	//
	ttX[0] = ring->tmat[0] * tX;
	ttX[1] = ring->tmat[3] * tX;
	ttX[2] = ring->tmat[6] * tX;

	ttY[0] = ring->tmat[1] * tY;
	ttY[1] = ring->tmat[4] * tY;
	ttY[2] = ring->tmat[7] * tY;

	gluLookAt(	eye[0], eye[1], eye[2],
				center[0], center[1], center[2],
				0.0, 1.0, 0.0	);

	glTranslatef(	ttX[0] + ttY[0], 
					ttX[1] + ttY[1], 
					ttX[2] + ttY[2]	);

	lpos[0] = eye[0];
	lpos[1] = eye[1];
	lpos[2] = eye[2];
	lpos[3] = 1.0f;
	glLightfv( GL_LIGHT0, GL_POSITION, lpos );
	glLightf( GL_LIGHT0, GL_CONSTANT_ATTENUATION, 0.3f );
	//glLightf( GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.1f );

	// lk halkann texture'si seilir
	tID = tunnel.ringLump[nRing].texID;
	glBindTexture( GL_TEXTURE_2D, tID );

	for ( i=nRing+1; i<toRing; i++ )
	{
		ring = &tunnel.ringLump[i];
		ringL = &tunnel.ringLump[i-1];

		if ( ringL->texID != tID )
		{
			tID = ringL->texID;
			glBindTexture( GL_TEXTURE_2D, tID );
		}

		glBegin( GL_QUAD_STRIP );

		for ( i2=0; i2<tunnel.numVertex; i2++ )
		{
			glNormal3fv( ring->normalLump[i2] );
			glTexCoord2fv( ring->texcoordLump[i2] );
			glVertex3fv( ring->vertexLump[i2] );

			glNormal3fv( ringL->normalLump[i2] );
			glTexCoord2fv( ringL->texcoordLump[i2] );
			glVertex3fv( ringL->vertexLump[i2] );
		}

		glNormal3fv( ring->normalLump[0] );
		glTexCoord2fv( ring->texcoordLump[i2] );
		glVertex3fv( ring->vertexLump[0] );

		glNormal3fv( ringL->normalLump[0] );
		glTexCoord2fv( ringL->texcoordLump[i2] );
		glVertex3fv( ringL->vertexLump[0] );

		glEnd();
	}
}
