#include "types.h"
#include "Ball.h"
#include "Arena.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

Ball  ball;
Arena arena;

bool mov_east=false, mov_west=false,mov_north=false,mov_south=false;

void initSDL(int width,int height,int bpp) {

   // Bu yoram SDL ktphanesini baslatan yordamdir. SDL ktphanesinin VIDEO
   // ve zamanlama kisimlarini kullanmayi dsndgmz iin buna uygun
   // parametreleri kullandik. Herhangi bir hata durumunda ise SDL_GetError()
   // yordami ile hatanin sebebini grenip ekrana (yada stdout.txt ktgne)
   // yazdiriyor ve programdan ikiyoruz.

   if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER) < 0) {
      fprintf(stderr,"SDL baslatiminda hata! %s",SDL_GetError());
      exit(-1);
   }

   // exit() yordami agirildiginda buna ek olarak SDL_Quit() isimli SDL yordaminin da
   // agirismasini asagidaki kod ile belirtmis oluyoruz. SDL_Quit() yordami SDL
   // ktphanesini kapatan yordamdir. Bu sekilde artik program sonunda SDL_Quit()
   // yordamini agirmak yerine sadece exit() yordami ile bu isin otomatik gereklesmesini
   // saglamis olduk.

   atexit(SDL_Quit);

   // Bu yordam ile nihayet genisligini, yksekligini ve renk znrlgn belirledigimiz
   // bir pencere aiyoruz. SDL_OPENGL  parametresi bu pencereyi OpenGL altindan
   // kullanacagimizi belirtiyor.

   if (SDL_SetVideoMode(width,height,bpp,SDL_OPENGL) == NULL) {
      fprintf(stderr,"SDL ekrani aamadi!");
      exit(-1);
   }

}

void setupOpenGL(int width,int height) {
   
   // poligonlarin cizim sirasinda oncelik kontrolu icin Z Buffer
   // teknigini kullan.
   glDepthFunc(GL_LESS);
   glEnable(GL_DEPTH_TEST);
   
   // poligonlarin icini doldurmada renk gecislerini yumusak yap 
   glShadeModel(GL_SMOOTH);
   
   // arka fon rengi siyah olsun
   glClearColor(0,0,0,0);

   // goruntuyu olusturacagimiz alani belirt.
   glViewport(0,0,width,height);

   
   // opengl de goruntu olusturulacakken kullanilacak sanal kameranin
   // lens ayarlarini gerceklestir (bakis acisi ve menzil ayarlari...)
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(45,(float)width/(float)height,0.1f,4000.0f);
   glMatrixMode(GL_MODELVIEW);

}

void renderScene() {

   // Onceki seferde cizilenleri siliyoruz. Ayni zamanda Z Buffer
   // algoritmasinin duzgun islemesi icin Z Buffer daki onceki seferden
   // kalma bilgilerde sifirlaniyor.
   
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   
   // Kamera poziyonunu sfrlyoruz.
   glLoadIdentity();

   // Kameramizi biraz geri alalim ki dnyadaki izimleri gzlemleyelim..
   // (Yani cisimler kameranin arkasinda kalmasinlar...)
   // Ayrica Kamera bakis acisi ile oynayarak oyun alanina ustten
   // bakiyoruz..
   glTranslatef(0.0f,-10.0f,-60.0f);
   glRotatef(20,1,0,0);
   
   // Z ekseni dogrultusunda bir hareket durumu varsa bunu uyguluyoruz.
   if (mov_north) {
      static const Vec3d deltaz = {0,0,-0.1};
      ball.move(&deltaz);
   }
   else
   if (mov_south) {
      static const Vec3d deltaz = {0,0,0.1};
      ball.move(&deltaz);
   }

   // X ekseni dogrultusundaki hareket durumunu uyguluyoruz.
   if (mov_east) {
      static const Vec3d deltax = {0.1,0,0};
      ball.move(&deltax);
   }
   else
   if (mov_west) {
      static const Vec3d deltax = {-0.1,0,0};
      ball.move(&deltax);
   }
   
   // topu ciz.
   ball.render();

   // oyun alanini ciz..
   glColor3f(0.9,0.2,0.1);
   arena.render();
      
   // Bellekte olusturulan cizim pencere icine aktariliyor. Bu sekilde
   // goruntuyu ekranda gorebiliyoruz.

   SDL_GL_SwapBuffers();

}

int main(int argc,char *argv[]) {

   // Ana donguden cikis icin kullandigimiz degiskenimiz.

   bool quit = false;

   // SDL ktphanesini balatp, ekranda bir pencere aiyoruz.
   
   initSDL(640,480,16);
   setupOpenGL(640,480);

   ball.setPosition(0,0,0);
   ball.setColor(0.1,0.2,0.9);

   while (!quit) {

      renderScene();
      
      // SDL de giris/cikis islemleri event ler vasitasi ile yurutulur.
      // Burada bir event nesnesi tanimi yapiyoruz.
      
      SDL_Event event;

      // SDL_PollEvent() fonksiyonu ile hazirda bekleyen birsonraki event i
      // event yapisi icerisinde elde ediyoruz. 

      while (SDL_PollEvent(&event)) {

         // event.type bize event in turunu belirtir. SDL_KEYDOWN tipi tusa
         // basilma durumunda olusur.
         
         switch (event.type) {
         
            case SDL_KEYDOWN:
               
               // event.key.keysym.sym degiskeni basilan tusun kodunu icermektedir.
               // SDL icerisinde tus kodlari SDLK_* biciminde tanimlanmistir. Kod
               // SDLK_ESCAPE ise kontrol degiskenimizi gunleyerek donguden cikma isini
               // gerceklestiriyoruz.
               
               switch (event.key.keysym.sym) {
                  case SDLK_ESCAPE:
                     quit = true;
                     break;

                  // Yukari ok tusuna basiliyor ise kuzeye(-z yonu) gitme olayini aktif et.
                  // Ayni anda hem kuzey hemde guneye(-z yonu) gidilemeyeceginden
                  // guneye gidilme durumunu ortadan kaldiriyoruz.
                  case SDLK_UP:
                     mov_north = true;
                     mov_south = false;
                     break;

                  // Yukarida yaptigimiz islemi bu seferde tersi durum
                  // icin gerceklestiriyoruz.
                  case SDLK_DOWN:
                     mov_north = false;
                     mov_south = true;
                     break;

                  // +x ve -x yonlerindeki hareketler icin yine +z -z
                  // durumlarinda davrandigimiz gibi davraniyoruz.
                  case SDLK_LEFT:
                     mov_east = false;
                     mov_west = true;
                     break;

                  case SDLK_RIGHT:
                     mov_east = true;
                     mov_west = false;
                     break;

               }
               break;

            // Basilan bir tus birakildigi zaman SDL_KEYUP event i olusur.
               
            case SDL_KEYUP:

               switch (event.key.keysym.sym) {
                  
               
                  // kuzeye gidilme durumunu iptal ediyoruz..
                  case SDLK_UP:
                     mov_north = false;
                     break;

                  // guneye gidilme durumunu iptal ediyoruz..
                  case SDLK_DOWN:
                     mov_south = false;
                     break;

                  // batiya (-x) gidilme durumu ortadan kaldiriliyor
                  case SDLK_LEFT:
                     mov_west = false;
                     break;

                  // doguya (+x) gidilme durumu sonlandiriliyor.
                  case SDLK_RIGHT:
                     mov_east = false;
                     break;

               }
               break;

            // Pencerenin kapatma tusuna basilmasi ise yine bir event uretir.
            // Bu event in tipi SDL_QUIT dir. Bu durumda da yine cikis islemini
            // yapiyoruz.

            case SDL_QUIT:
               quit = true;

         }
      }

   }
   
    return 0;
}
