#pragma comment( lib, "wsock32.lib" )

#include <stdio.h>
#include <winsock2.h>

int main(int argc,char **argv) {

   // Simdi de sistemdeki winsock alt yapisini aktif hale getirmek iin asagidaki kodu yazalim..

   WSAData wsaData;
   if (WSAStartup(MAKEWORD(1, 1), &wsaData) != 0) {
       printf("socket sistem baslatma hatasi! (WSAStartup...)");
   }

   // Bu islemin %99.9 basari ile tamamlanmasi gerekir..
   // Simdi ise karsi haberlesmeye geecegimiz bilgisayarin (karsi taraf)
   // adresini belirmek iin bir yapiyi uygun sekilde dolduralim..

   // dolduracagimiz yapi bu
   sockaddr_in sinIgInterfaceSend_remote;

   // bu parametre AF_INET olmali
   sinIgInterfaceSend_remote.sin_family = AF_INET;

   // bu parametreye karsi tarafin IP adresi yada host adi gelecek..
   sinIgInterfaceSend_remote.sin_addr.s_addr = inet_addr("127.0.0.1");

   // karsi tarafin port numarasi
   sinIgInterfaceSend_remote.sin_port = htons(19998);

   // ve blogun bir kismini sifirlamamiz gerekiyor..
   memset(&sinIgInterfaceSend_remote.sin_zero,0,8);

   // Simdide iletisimde kullanacigimiz socket i olusturalim..
   // SOCK_DGRAM parametresi haberlesme yntemi olarak UDP kullanacagimizi belirtiyor.
   SOCKET socket_send = socket(AF_INET,SOCK_DGRAM,0);

   //Evet artik UDP haberlesmesi iin gerekli hazirliklari tamamladik.
   // Simdi sira karsi tarafa veri gndermekte.. Bu is iin sendto(...) foksiyonunu/ kullanacagiz.

   const char *mesaj = "merhaba";
   int result = sendto(socket_send,mesaj,strlen(mesaj),0,(struct sockaddr *)&sinIgInterfaceSend_remote,sizeof(struct sockaddr));
   if (result == SOCKET_ERROR)
       printf("socket hatasi");
   else
       printf("veri gnderildi: gnderilen byte: %d",result);

   return 0;
}
