#pragma comment( lib, "wsock32.lib" )

#include <stdio.h>
#include <winsock2.h>


int main(int argc,char **argv) {

   WSAData wsaData;
   if (WSAStartup(MAKEWORD(1, 1), &wsaData) != 0) {
       printf("socket sistem baslatma hatasi! (WSAStartup...)");
   }

   // Simdide veri almak istedigimiz port numarasini sisteme belirtmek iin bir yapiyi doldurmamiz gerekiyor.
   sockaddr_in sinIgInterfaceRecv_local;

   // Bu parametre AF_INET olmali
   sinIgInterfaceRecv_local.sin_family = AF_INET;

   // Bu paramtre de aynen korunacak.
   sinIgInterfaceRecv_local.sin_addr.s_addr = htonl(INADDR_ANY);

   // Bu parametrede veriyi okuyacagimiz portu belirtiyoruz.
   // Buraya istemci uygulamada kullandigimiz port numarasini aynen yazmamiz gerekiyor.
   sinIgInterfaceRecv_local.sin_port = htons(19998);

   // Bu tarafida sifirlayalim..
   memset(&sinIgInterfaceRecv_local.sin_zero,0,8);

   // Istemcide oldugu gibi socket imizi olusturuyoruz..
   SOCKET igsocket_recv = socket(AF_INET,SOCK_DGRAM,0);

   // Bu noktaya kadar istemi ile sunucu kodlari arasinda pek bir fark yok.
   // Sunucu uygulamasinda veri almaya baslamadan nce yapmamiz gereken
   // son bir adim daha kaldi. Bu adim ile hazirladigimzi adres yapisini socket e
   // bagliyoruz. Yani socket imizi adreslendirmis oluyoruz aslinda.

   if (bind(igsocket_recv, (struct sockaddr*) &sinIgInterfaceRecv_local, sizeof(struct sockaddr)) < 0) {
       printf("socket baglama hatasi!");
   }

   // bind(...) fonksiyonunun geri dns degeri negatif ise baglamada bir hata olusmus demektir.
   // bu tarz hatalar genelde kullanimda olan bir porta baglanmaya alistigimizda
   // ortaya ikar..

   // Ve simdide son olarak sira veri okumaya geldi.. Veri okumak iin recvfrom(...) fonksiyonunu kullanacagiz.

   char mesaj[256];
   int result = recvfrom(igsocket_recv,mesaj,255,0,0,0);
   if (result != SOCKET_ERROR)
       printf("alinan mesaj: %s",mesaj);

   return 0;
}