#include "types.h"
#include "Ball.h"
#include "Arena.h"
#include "Player.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Oyuncular icin pl1, pl2 nesneleri kullanilirken, oyun alani
// arena nesnesi ile ifade ediliyor.
Player pl1;
Player pl2;
Arena  arena;

// Bu ornegimizde 2 oyuncuda klavyeden idare edilebildigi icin,
// gecen orneklerimize ek olarak 1. ve 2. oyuncular icin ayri ayri hareket
// kontrol degiskenleri tanimlamamiz gerekiyor.
bool mov_east_1=false,mov_west_1=false,mov_north_1=false,mov_south_1=false;
bool mov_east_2=false,mov_west_2=false,mov_north_2=false,mov_south_2=false;

// Bu degiskeni oyun icerisinde zamanlama araci olarak kullaniyoruz.
long old_time = 0;

void initSDL(int width,int height,int bpp) {

   // Bu yoram SDL ktphanesini baslatan yordamdir. SDL ktphanesinin VIDEO
   // ve zamanlama kisimlarini kullanmayi dsndgmz iin buna uygun
   // parametreleri kullandik. Herhangi bir hata durumunda ise SDL_GetError()
   // yordami ile hatanin sebebini grenip ekrana (yada stdout.txt ktgne)
   // yazdiriyor ve programdan ikiyoruz.

   if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER) < 0) {
      fprintf(stderr,"SDL baslatiminda hata! %s",SDL_GetError());
      exit(-1);
   }

   // exit() yordami agirildiginda buna ek olarak SDL_Quit() isimli SDL yordaminin da
   // agirismasini asagidaki kod ile belirtmis oluyoruz. SDL_Quit() yordami SDL
   // ktphanesini kapatan yordamdir. Bu sekilde artik program sonunda SDL_Quit()
   // yordamini agirmak yerine sadece exit() yordami ile bu isin otomatik gereklesmesini
   // saglamis olduk.

   atexit(SDL_Quit);

   // Bu yordam ile nihayet genisligini, yksekligini ve renk znrlgn belirledigimiz
   // bir pencere aiyoruz. SDL_OPENGL  parametresi bu pencereyi OpenGL altindan
   // kullanacagimizi belirtiyor.

   if (SDL_SetVideoMode(width,height,bpp,SDL_OPENGL) == NULL) {
      fprintf(stderr,"SDL ekrani aamadi!");
      exit(-1);
   }

}

void setupOpenGL(int width,int height) {
   
   // poligonlarin cizim sirasinda oncelik kontrolu icin Z Buffer
   // teknigini kullan.
   glDepthFunc(GL_LESS);
   glEnable(GL_DEPTH_TEST);
   
   // poligonlarin icini doldurmada renk gecislerini yumusak yap 
   glShadeModel(GL_SMOOTH);
   
   // arka fon rengini belirliyoruz
   glClearColor(0.1,0.1,0.1,0);

   // goruntuyu olusturacagimiz alani belirt.
   glViewport(0,0,width,height);

   // opengl de goruntu olusturulacakken kullanilacak sanal kameranin
   // lens ayarlarini gerceklestir (bakis acisi ve menzil ayarlari...)
   // Teknik olarak: OpenGL sistemi projection matrisini goruntuyu
   // ekrana getirme islemi sirasinda kullanir. Biz burada projection
   // matrisine verdigimiz degerler ile, ekranda olusacak 2 boyutlu
   // goruntunun ozelliklerini belirtmis oluyoruz.
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(45,(float)width/(float)height,0.1f,4000.0f);
   glMatrixMode(GL_MODELVIEW);

}

void renderScene() {

   // Bu degisken oyun alanini dondurme isleminde kullanilan aciyi tutar..
   static float rotangle = 0;
   
   // Kodun asagidaki kisminda dt degiskeni icerisinde renderScene() yordaminin
   // son cagirimindan bu yana gecen zamani saniye cinsinden hesapliyoruz..
   // Daha sonra tum rotation ve translation islemlerinde carpan olarak bu dt
   // degiskenini kullandigimiz taktirde, frame rate den bagimsiz olarak calisan bir
   // oyun elde etmis oluruz. Yani oyunumuz bir pII de de bir PIV de de ayni
   // hizda calisir..
   long  now = SDL_GetTicks();
   float dt  = (float) (now - old_time) / 1000.0f;
   old_time  = now;
   
   // Onceki seferde cizilenleri siliyoruz. Ayni zamanda Z Buffer
   // algoritmasinin duzgun islemesi icin Z Buffer daki onceki seferden
   // kalma bilgilerde sifirlaniyor.
   
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   
   // Kamera poziyonunu sfrlyoruz. (modelview matrisi resetleniyor)
   glLoadIdentity();

   // Kameramizi biraz geri alalim ki dnyadaki izimleri gzlemleyelim..
   // (Yani cisimler kameranin arkasinda kalmasinlar...)
   // Ayrica Kamera bakis acisi ile oynayarak oyun alanina ustten
   // bakiyoruz..
   // Teknik olarak burada yaptigimiz ise: ModelView olarak adlandirilan
   // opengl matrisi uzerinde oynamalar yaparak referans koordinat sistemini
   // ekranin icine dogru atmak. Yapilan cizim islemleri bu koordinat sistemine
   // goreli olarak gerceklestirileceginden cisimlerde bizden uzakta cikacaklardir.
   glTranslatef(0.0f,-10.0f,-120.0f);
   glRotatef(20,1,0,0);
   
   // Bu kod ile 1. oyuncunun oyun alani sinirlari disina cikip cikmadigini
   // kabaca belirliyoruz. Eger disari ciknma durumu var ise, oyuncu gidis
   // yonunu oyun alani merkezine dogru (0,0,0) ceviriyoruz.. Boylece oyuncu
   // hicbir zaman oyun alani disina cikamiyor..
   if (arena.isOutside(pl1.getPosition())) {
      Vec3d pos = pl1.getPosition();
      pl1.setDirection(-pos.x,-pos.y,-pos.z);
   }

   // yukarida belirttigimiz islemi bu kez de 2. oyuncu icin uyguluyoruz..
   if (arena.isOutside(pl2.getPosition())) {
      Vec3d pos = pl2.getPosition();
      pl2.setDirection(-pos.x,-pos.y,-pos.z);
   }
   
   // Eger oyuncular birbirlerine carpiyorlar ise, gidis yonlerini tersine
   // cevirerek oyuncularin sekme hareketi yapmalarini sagliyoruz. Kodun bu kisminda
   // bazi problemler bulunmakta. Ileride bu kisma duzgun isleyen bir fiziksel
   // gerceklestirim yerlestirerek aksakliklarin ustesinden gelmeye calisacagiz..
   if (pl1.hitToPlayer(&pl2)) {

      Vec3d dir = pl1.getDirection();
      pl1.setDirection(-dir.x,-dir.y,-dir.z);
      
      dir = pl2.getDirection();
      pl2.setDirection(-dir.x,-dir.y,-dir.z);

   }

   // oyuncu pozisyonunu tusa basilma durumlarina gore guncellestir
   pl1.updatePosition(mov_north_1,mov_south_1,mov_east_1,mov_west_1,dt);
   pl2.updatePosition(mov_north_2,mov_south_2,mov_east_2,mov_west_2,dt);
   
   // oyunculari ciz
   pl1.render();
   pl2.render();

   // oyun alanini ciz.. Ayrica oyun alanini dondurmeyi de ihmal etmiyoruz..
   glColor3f(0.2,0.7,0.1);
   glPushMatrix();
      glRotatef(rotangle,0,1,0);
      arena.render();
   glPopMatrix();
      
   // Bellekte olusturulan goruntu cizim penceresi icine aktariliyor. Bu sekilde
   // goruntuyu ekranda gorebiliyoruz.
   SDL_GL_SwapBuffers();

   // oyun alani dondurmede kullanilan degisken frame rate den bagimsiz bicimde
   // guncelleniyor...
   rotangle += 20.0f * dt;

}

int main(int argc,char *argv[]) {

   // Ana donguden cikis icin kullandigimiz degiskenimiz.

   bool quit = false;

   // SDL ktphanesini balatp, ekranda bir pencere aiyoruz.
   initSDL(640,480,16);
   setupOpenGL(640,480);

   // Oyunculari oyun alani icerisinde konumlandiriyor, renklerini belirliyoruz.
   // Ayrica oyun alaninin yaricapida burada belirleniyor.
   pl1.setPosition(-5,0,0);
   pl2.setPosition(5,0,0);
   pl1.setColor(1,0,0);
   pl2.setColor(0,0,1);
   arena.setRadius(50);
   
   while (!quit) {

      // Her program dongusunde 1 kez render islemini gerceklestiriyoruz.
      renderScene();
      
      // SDL de giris/cikis islemleri event ler vasitasi ile yurutulur.
      // Burada bir event nesnesi tanimi yapiyoruz.
      SDL_Event event;

      // SDL_PollEvent() fonksiyonu ile hazirda bekleyen birsonraki event i
      // event yapisi icerisinde elde ediyoruz. 
      while (SDL_PollEvent(&event)) {

         // event.type bize event in turunu belirtir. SDL_KEYDOWN tipi tusa
         // basilma durumunda olusur.
         
         switch (event.type) {
         
            case SDL_KEYDOWN:
               
               // event.key.keysym.sym degiskeni basilan tusun kodunu icermektedir.
               // SDL icerisinde tus kodlari SDLK_* biciminde tanimlanmistir. Kod
               // SDLK_ESCAPE ise kontrol degiskenimizi gunleyerek donguden cikma isini
               // gerceklestiriyoruz.
               
               switch (event.key.keysym.sym) {
                  case SDLK_ESCAPE:
                     quit = true;
                     break;

                  // Yukari ok tusuna basiliyor ise kuzeye(-z yonu) gitme olayini aktif et.
                  // Ayni anda hem kuzey hemde guneye(-z yonu) gidilemeyeceginden
                  // guneye gidilme durumunu ortadan kaldiriyoruz.
                  case SDLK_UP:
                     mov_north_1 = true;
                     mov_south_1 = false;
                     break;

                  // Yukarida yaptigimiz islemi bu seferde tersi durum
                  // icin gerceklestiriyoruz.
                  case SDLK_DOWN:
                     mov_north_1 = false;
                     mov_south_1 = true;
                     break;

                  // +x ve -x yonlerindeki hareketler icin yine +z -z
                  // durumlarinda davrandigimiz gibi davraniyoruz.
                  case SDLK_LEFT:
                     mov_east_1 = false;
                     mov_west_1 = true;
                     break;

                  case SDLK_RIGHT:
                     mov_east_1 = true;
                     mov_west_1 = false;
                     break;

                  // ayni kontroller bu kez 2. tus takimi icin yapiliyor..
                  case SDLK_w:
                     mov_north_2 = true;
                     mov_south_2 = false;
                     break;

                  // Yukarida yaptigimiz islemi bu seferde tersi durum
                  // icin gerceklestiriyoruz.
                  case SDLK_s:
                     mov_north_2 = false;
                     mov_south_2 = true;
                     break;

                  // +x ve -x yonlerindeki hareketler icin yine +z -z
                  // durumlarinda davrandigimiz gibi davraniyoruz.
                  case SDLK_a:
                     mov_east_2 = false;
                     mov_west_2 = true;
                     break;

                  case SDLK_d:
                     mov_east_2 = true;
                     mov_west_2 = false;
                     break;

               }
               break;

            // Basilan bir tus birakildigi zaman SDL_KEYUP event i olusur.
               
            case SDL_KEYUP:

               switch (event.key.keysym.sym) {
                  
               
                  // kuzeye gidilme durumunu iptal ediyoruz..
                  case SDLK_UP:
                     mov_north_1 = false;
                     break;

                  // guneye gidilme durumunu iptal ediyoruz..
                  case SDLK_DOWN:
                     mov_south_1 = false;
                     break;

                  // batiya (-x) gidilme durumu ortadan kaldiriliyor
                  case SDLK_LEFT:
                     mov_west_1 = false;
                     break;

                  // doguya (+x) gidilme durumu sonlandiriliyor.
                  case SDLK_RIGHT:
                     mov_east_1 = false;
                     break;

                  case SDLK_w:
                     mov_north_2 = false;
                     break;

                  // guneye gidilme durumunu iptal ediyoruz..
                  case SDLK_s:
                     mov_south_2 = false;
                     break;

                  // batiya (-x) gidilme durumu ortadan kaldiriliyor
                  case SDLK_a:
                     mov_west_2 = false;
                     break;

                  // doguya (+x) gidilme durumu sonlandiriliyor.
                  case SDLK_d:
                     mov_east_2 = false;
                     break;

               }
               break;

            // Pencerenin kapatma tusuna basilmasi ise yine bir event uretir.
            // Bu event in tipi SDL_QUIT dir. Bu durumda da yine cikis islemini
            // yapiyoruz.

            case SDL_QUIT:
               quit = true;

         }
      }

   }
   
   return 0;
}
