#include "Entity.h"
#include <math.h>

void Entity :: move(const Vec3d *delta) {

   position.x += delta->x;
   position.y += delta->y;
   position.z += delta->z;

}

void Entity :: setPosition(float x,float y,float z) {

   position.x = x;
   position.y = y;
   position.z = z;

}

Vec3d Entity :: getPosition() const {

   return position;

}

float Entity :: getCollisionRadius() const {
   return colRadius;
}

void  Entity :: setCollisionRadius(float rad) {
   this->colRadius = rad;
}

bool Entity :: isHit(Entity *ent) const {

   Vec3d epos  = ent->getPosition();
   Vec3d delta = {position.x-epos.x,position.y-epos.y,position.z-epos.z};
   float dlen  = sqrt(delta.x*delta.x+delta.y*delta.y+delta.z*delta.z);

   return (dlen < colRadius + ent->getCollisionRadius());

}

