// *****************************************
//
// Oyun Yapimi Dersleri [www.oyunyapimi.org]
//
// Deniz Aydinoglu :: 2002 ::
//
// deniz@oyunyapimi.org
//
// *****************************************

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

#include <gl/gl.h>
#include <gl/glu.h>
#include <gl/glut.h>
#include <gl/glut.h>
#include <sdl/sdl.h>

#include <stdio.h>
#include <stdlib.h>

void initSDL(int width,int height,int bpp) {

   // Bu yoram SDL ktphanesini baslatan yordamdir. SDL ktphanesinin VIDEO
   // ve zamanlama kisimlarini kullanmayi dsndgmz iin buna uygun
   // parametreleri kullandik. Herhangi bir hata durumunda ise SDL_GetError()
   // yordami ile hatanin sebebini grenip ekrana (yada stdout.txt ktgne)
   // yazdiriyor ve programdan ikiyoruz.

   if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER) < 0) {
      fprintf(stderr,"SDL baslatiminda hata!\n%s",SDL_GetError());
      exit(-1);
   }

   // exit() yordami agirildiginda buna ek olarak SDL_Quit() isimli SDL yordaminin da
   // agirismasini asagidaki kod ile belirtmis oluyoruz. SDL_Quit() yordami SDL
   // ktphanesini kapatan yordamdir. Bu sekilde artik program sonunda SDL_Quit()
   // yordamini agirmak yerine sadece exit() yordami ile bu isin otomatik gereklesmesini
   // saglamis olduk.

   atexit(SDL_Quit);

   // Bu yordam ile nihayet genisligini, yksekligini ve renk znrlgn belirledigimiz
   // bir pencere aiyoruz. SDL_OPENGL  parametresi bu pencereyi OpenGL altindan
   // kullanacagimizi belirtiyor.

   if (SDL_SetVideoMode(width,height,bpp,SDL_OPENGL) == NULL) {
      fprintf(stderr,"SDL ekrani aamadi!");
      exit(-1);
   }

}

void setupOpenGL(int width,int height) {
   
   // poligonlarin cizim sirasinda oncelik kontrolu icin Z Buffer
   // teknigini kullan.
   glDepthFunc(GL_LESS);
   glEnable(GL_DEPTH_TEST);
   
   // poligonlarin icini doldurmada renk gecislerini yumusak yap 
   glShadeModel(GL_SMOOTH);
   
   // arka fon rengi siyah olsun
   glClearColor(0,0,0,0);

   // goruntuyu olusturacagimiz alani belirt.
   glViewport(0,0,width,height);

   
   // opengl de goruntu olusturulacakken kullanilacak sanal kameranin
   // lens ayarlarini gerceklestir (bakis acisi ve menzil ayarlari...)
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(45,(float)width/(float)height,4,4000);
   glMatrixMode(GL_MODELVIEW);

}

void renderScene() {

   // Onceki seferde cizilenleri siliyoruz. Ayni zamanda Z Buffer
   // algoritmasinin duzgun islemesi icin Z Buffer daki onceki seferden
   // kalma bilgilerde sifirlaniyor.
   
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   // Bellekte olusturulan cizim pencere icine aktariliyor. Bu sekilde
   // goruntuyu ekranda gorebiliyoruz.

   SDL_GL_SwapBuffers();

}

int main(int argc,char *argv[]) {

   // Ana donguden cikis icin kullandigimiz degiskenimiz.

   bool quit = false;

   // SDL ktphanesini balatp, ekranda bir pencere aiyoruz.
   
   initSDL(640,480,16);
   setupOpenGL(640,480);

      
   while (!quit) {

      renderScene();
      
      // SDL de giris/cikis islemleri event ler vasitasi ile yurutulur.
      // Burada bir event nesnesi tanimi yapiyoruz.
      
      SDL_Event event;

      // SDL_PollEvent() fonksiyonu ile hazirda bekleyen birsonraki event i
      // event yapisi icerisinde elde ediyoruz. 

      while (SDL_PollEvent(&event)) {

         // event.type bize event in turunu belirtir. SDL_KEYDOWN tipi tusa
         // basilma durumunda olusur.
         
         switch (event.type) {
         
            case SDL_KEYDOWN:
               
               // event.key.keysym.sym degiskeni basilan tusun kodunu icermektedir.
               // SDL icerisinde tus kodlari SDLK_* biciminde tanimlanmistir. Kod
               // SDLK_ESCAPE ise kontrol degiskenimizi gunleyerek donguden cikma isini
               // gerceklestiriyoruz.
               
               switch (event.key.keysym.sym) {
                  case SDLK_ESCAPE:
                     quit = true;
                     break;
               }
               break;

            // Pencerenin kapatma tusuna basilmasi ise yine bir event uretir.
            // Bu event in tipi SDL_QUIT dir. Bu durumda da yine cikis islemini
            // yapiyoruz.

            case SDL_QUIT:
               quit = true;

         }
      }

   }
   
	return 0;
}
