#include <math.h>
#include "math3d.h"

void VecNormalize3f( vec3f_t *vec )
{
	float length;

	length = sqrtf( vec->x*vec->x + vec->y*vec->y + vec->z*vec->z );

	vec->x /= length;
	vec->y /= length;
	vec->z /= length;
}

vec3f_t VecDot3f( vec3f_t vec1, vec3f_t vec2 )
{
	vec3f_t dot;

	dot.x = vec1.x * vec2.x;
	dot.y = vec1.y * vec2.y;
	dot.z = vec1.z * vec2.z;

	return dot;
}

vec3f_t VecCross3f(vec3f_t v1, vec3f_t v2)
{
	vec3f_t cross;

	cross.x = v1.y*v2.z - v1.z*v2.y;
	cross.y = v1.z*v2.x - v1.x*v2.z;
	cross.z = v1.x*v2.y - v1.y*v2.x;

	return cross;
}

vec3f_t VecSub(vec3f_t v1, vec3f_t negv2)
{
	vec3f_t sub;

	sub.x = v1.x - negv2.x;
	sub.y = v1.y - negv2.y;
	sub.z = v1.z - negv2.z;

	return sub;
}

vec3f_t	VecSet(float x, float y, float z)
{
	vec3f_t set;
	
	set.x = x;
	set.y = y;
	set.z = z;

	return set;
}

vec3f_t VecGetCenter(vec3f_t v1, vec3f_t v2, vec3f_t v3)
{
	vec3f_t vc;

	vc.x = (v1.x + v2.x + v3.x)/3;
	vc.y = (v1.y + v2.y + v3.y)/3;
	vc.z = (v1.z + v2.z + v3.z)/3;
	
	return vc;
}

void VecBolSabit3f( vec3f_t *vec, float bol )
{
	vec->x /= bol;
	vec->y /= bol;
	vec->z /= bol;
}

vec3f_t VecTopla( vec3f_t v1, vec3f_t v2 )
{
	vec3f_t v;

	v.x = v1.x + v2.x;
	v.y = v1.y + v2.y;
	v.z = v1.z + v2.z;

	return v;
}