/*
 * INTRO
 *
 * :: Deniz Aydinoglu    :: 2003 ::
 * :: www.oyunyapimi.org :: 2003 ::
 *
 */

#include "init.h"
#include <stdlib.h>

bool APP_QUIT = false;

void exitSDL() {
   endApp();
   SDL_Quit();
}

void initSDL(int width,int height,int bpp) {


   if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER) < 0) {
      fprintf(stderr,"SDL baslatiminda hata! %s",SDL_GetError());
      exit(-1);
   }

   atexit(exitSDL);

   if (SDL_SetVideoMode(width,height,bpp,SDL_OPENGL | FULL_SCREEN) == NULL) {
      fprintf(stderr,"SDL pencereyi aamadi!");
      exit(-1);
   }

}

void setupOpenGL(int width,int height) {
   
   glDepthFunc(GL_LESS);
   glEnable(GL_DEPTH_TEST);
   glShadeModel(GL_SMOOTH);
   glClearColor(0,0,0,0);
   glViewport(0,0,width,height);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(45,(float)width/(float)height,0.1f,4000.0f);
   glMatrixMode(GL_MODELVIEW);

}

int main(int argc,char *argv[]) {

   initSDL(800,600,32);
   setupOpenGL(800,600);
   initApp();

   while (!APP_QUIT) {

      renderScene();
      
      SDL_Event event;
      while (SDL_PollEvent(&event)) {

         switch (event.type) {
         
            case SDL_KEYDOWN:
               keyPressed(event.key.keysym.sym);
               break;

            case SDL_KEYUP:
               keyReleased(event.key.keysym.sym);
               break;

            case SDL_QUIT:
               APP_QUIT = true;

         }
      }

   }
   
   return 0;
}
