unit custom3D;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,math, ExtCtrls, StdCtrls;

type point  =record
 x,y,z:Real;
end;
type line =record
x1,x2,y1,y2:Real;
end;

type cube=record
n:array[1..8] of point;
end;

type Ucgenoid=record
n:array[1..4] of point;
end;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    ScrollBar1: TScrollBar;
    ScrollBar2: TScrollBar;
    function CreateUcgenoid(tepex,tepey,tepez,kenar:real):Ucgenoid;
    procedure RenderUcgenoid(mUcgenoid:Ucgenoid);

    function CreateCube(centerx,centery,centerz,side:real):Cube;
    procedure RenderCube(mCube:Cube);

    procedure FormCreate(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


var
  Form1: TForm1;
  points:array[1..4] of point;
  hAngle,vAngle:real;
  gUnit,hgUnit,sUnit:Integer;
  prex,prey:Integer;
  iste:Cube;
  ucgen:Ucgenoid;
const fixer=180/pi;
implementation

{$R *.dfm}
function perX(x,y,z: real): integer;
begin
     result:=200+round(x*cos(hAngle*fixer)+z*sin(hAngle*fixer));
end;

function perY(x,y,z: real): integer;
begin
     result:=200+round((-y*cos(vAngle*fixer)+(-x*sin(hAngle*fixer)+z*cos(hAngle*fixer))*sin(vAngle*fixer)));
end;

function TForm1.CreateUcgenoid(tepex,tepey,tepez,kenar:real):Ucgenoid;
var i:integer;

begin
with result do
begin
n[1].x := tepex;
n[1].y := tepey;
n[1].z := tepez;

n[2].x := tepex+kenar/2;
n[2].y := tepey-kenar*sqrt(3);
n[2].z := tepez;

n[3].x := tepex-kenar/2;
n[3].y := tepey-kenar*sqrt(3);
n[3].z := tepez;

n[4].x := tepex;
n[4].y := tepey-kenar*sqrt(3);
n[4].z := tepez+kenar*sqrt(3);


end;
end;

procedure TForm1.RenderUcgenoid(mUcgenoid:Ucgenoid);
var i:Integer;
begin

canvas.Pen.Color :=clOlive;
with mUcgenoid do
begin
canvas.MoveTo(perX(n[1].x,n[1].y,n[1].z),perY(n[1].x,n[1].y,n[1].z));
canvas.LineTo(perX(n[2].x,n[2].y,n[2].z),perY(n[2].x,n[2].y,n[2].z));
canvas.LineTo(perX(n[4].x,n[4].y,n[4].z),perY(n[4].x,n[4].y,n[4].z));
canvas.LineTo(perX(n[3].x,n[3].y,n[3].z),perY(n[3].x,n[3].y,n[3].z));
canvas.LineTo(perX(n[1].x,n[1].y,n[1].z),perY(n[1].x,n[1].y,n[1].z));
canvas.LineTo(perX(n[4].x,n[4].y,n[4].z),perY(n[4].x,n[4].y,n[4].z));
canvas.MoveTo(perX(n[2].x,n[2].y,n[2].z),perY(n[2].x,n[2].y,n[2].z));
canvas.LineTo(perX(n[3].x,n[3].y,n[3].z),perY(n[3].x,n[3].y,n[3].z));

canvas.Font.Color :=clBlue;
for i:=1 to 4 do
        canvas.TextOut(perX(n[i].x,n[i].y,n[i].z),perY(n[i].x, n[i].y,n[i].z),'x'+inttostr(i));

end;


end;

procedure TForm1.FormCreate(Sender: TObject);
begin
hAngle:=0;
vAngle:=0;
iste:=CreateCube(100,100,0,100);
ucgen:=CreateUcgenoid( 100,50*sqrt(3),0,100);


end;

function TForm1.CreateCube(centerx,centery,centerz,side:real):Cube;
var t:Integer;
begin
with result do
begin
//x: eer noktalar tekse,merkezin solunda kalyorlar
//demektir,bu da xlerinin centerdan kenar'n yars
//kadar eksik olacan gsterir,iftler iin tam tersi
//geerlidir.Bu genel bir kural deildir,srf kod biraz
//ksalsn diye benim getirdiim bir dzenleme...
   for t:=1 to 8 do
   if odd(t) then
   n[t].x :=centerx-side/2
   else
   n[t].x :=centerx+side/2;
   //y
   for t:=1 to 4 do
   n[t].y :=centery+side/2;
   for t:=5 to 8 do
   n[t].y :=centery-side/2;
   //z
   n[1].z :=centerz+side/2;
   n[2].z :=centerz+side/2;
   n[7].z :=centerz+side/2;
   n[8].z :=centerz+side/2;
   n[3].z :=centerz-side/2;
   n[4].z :=centerz-side/2;
   n[5].z :=centerz-side/2;
   n[6].z :=centerz-side/2;


end;
end;
procedure TForm1.RenderCube(mCube:Cube);
var i:Integer;
begin
//
with mcube do
begin

canvas.Pen.Color :=clGreen;
//ceiling
canvas.MoveTo(perX(n[1].x,n[1].y,n[1].z),perY(n[1].x,n[1].y,n[1].z));
canvas.LineTo(perX(n[2].x,n[2].y,n[2].z),perY(n[2].x,n[2].y,n[2].z));
canvas.LineTo(perX(n[4].x,n[4].y,n[4].z),perY(n[4].x,n[4].y,n[4].z));
canvas.LineTo(perX(n[3].x,n[3].y,n[3].z),perY(n[3].x,n[3].y,n[3].z));
canvas.LineTo(perX(n[1].x,n[1].y,n[1].z),perY(n[1].x,n[1].y,n[1].z));
//floor
canvas.MoveTo(perX(n[5].x,n[5].y,n[5].z),perY(n[5].x,n[5].y,n[5].z));
canvas.LineTo(perX(n[6].x,n[6].y,n[6].z),perY(n[6].x,n[6].y,n[6].z));
canvas.LineTo(perX(n[8].x,n[8].y,n[8].z),perY(n[8].x,n[8].y,n[8].z));
canvas.LineTo(perX(n[7].x,n[7].y,n[7].z),perY(n[7].x,n[7].y,n[7].z));
canvas.LineTo(perX(n[5].x,n[5].y,n[5].z),perY(n[5].x,n[5].y,n[5].z));

//sides
canvas.MoveTo(perX(n[1].x,n[1].y,n[1].z),perY(n[1].x,n[1].y,n[1].z));
canvas.LineTo(perX(n[7].x,n[7].y,n[7].z),perY(n[7].x,n[7].y,n[7].z));

canvas.MoveTo(perX(n[3].x,n[3].y,n[3].z),perY(n[3].x,n[3].y,n[3].z));
canvas.LineTo(perX(n[5].x,n[5].y,n[5].z),perY(n[5].x,n[5].y,n[5].z));

canvas.MoveTo(perX(n[2].x,n[2].y,n[2].z),perY(n[2].x,n[2].y,n[2].z));
canvas.LineTo(perX(n[8].x,n[8].y,n[8].z),perY(n[8].x,n[8].y,n[8].z));

canvas.MoveTo(perX(n[4].x,n[4].y,n[4].z),perY(n[4].x,n[4].y,n[4].z));
canvas.LineTo(perX(n[6].x,n[6].y,n[6].z),perY(n[6].x,n[6].y,n[6].z));

canvas.Font.Color :=clred;
for i:=1 to 8 do
        canvas.TextOut(perX(n[i].x,n[i].y,n[i].z),perY(n[i].x, n[i].y,n[i].z),'x'+inttostr(i));

end;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
vangle:=scrollbar1.Position ;
canvas.Brush.Color :=clWhite;
canvas.FillRect(rect(0,0,600,600));
renderCube(iste);
renderucgenoid(ucgen);
end;

procedure TForm1.ScrollBar2Change(Sender: TObject);
begin
hangle:=scrollbar2.Position ;
canvas.Brush.Color :=clWhite;
canvas.FillRect(rect(0,0,600,600));
renderucgenoid(ucgen);
renderCube(iste);
end;

end.
