//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "EnemyFire.h" 


EnemyFire::EnemyFire(unsigned int fireText,Vec3d position){
	
    fireTexture	 = fireText;	
    firePosition = position ;	

}

void EnemyFire::setFireRotation(float x,float y){
	
    incX = x;
    incY = y;	

}
void EnemyFire::updatePosition(float deltaTime){

    firePosition.x -= deltaTime * incX ;
    firePosition.y -= deltaTime * incY ;
	
} 

int EnemyFire::renderEnemyFire(float deltaTime){
	
    updatePosition(deltaTime);

    if (firePosition.x < MIN_X  || firePosition.y < MIN_Y || firePosition.y > MAX_Y-2) {			
        // fire grntden cikti
        return 1;
	}
		
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);

    glBindTexture(GL_TEXTURE_2D, fireTexture);
    glEnable(GL_TEXTURE_2D);					

    glPushMatrix();
        glTranslatef(firePosition.x,firePosition.y ,firePosition.z);

        glBegin(GL_QUADS);
            glTexCoord2f(1.0f,1.0f); glVertex3f( 0.5f, 0.5f,1.0f);
            glTexCoord2f(0.0f,1.0f); glVertex3f(-0.5f, 0.5f,1.0f);
            glTexCoord2f(0.0f,0.0f); glVertex3f(-0.5f,-0.5f,1.0f);
            glTexCoord2f(1.0f,0.0f); glVertex3f( 0.5f,-0.5f,1.0f);
        glEnd();

    glPopMatrix();

    glDisable(GL_TEXTURE_2D);		
	glDisable(GL_BLEND);
	
    //fire halen grntde
    return 0;

}