//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "EnemySmart.h"

EnemySmart::EnemySmart(float FireCreationTime){
	
    setObjectProperties();	

    boundingSphereRadius = 4;

    fireCreationTime = FireCreationTime;
    fireTimer = 0;

}

void EnemySmart::configureFireRotation(){
	
    float	distX,distY,vectorLength;
    float	increaseValue = 10;

    distX = position.x - shipPosition.x ;
    distY = position.y - shipPosition.y ;
	
    //distX ve distY ye gre olusturulmus olan vektorun uzunlugu bulunuyor
    vectorLength = sqrt ((distX*distX) + (distY*distY));

    //Vektor normallestirmesi, vektor lengthe gre yapiliyor.
    fireIncX = (distX / vectorLength) * increaseValue;
    fireIncY = (distY / vectorLength) * increaseValue;

}
		
//returnValue=1  fire ret
//returnValue=2  fire retme
//returnValue=3  enemy sil
int	EnemySmart::renderObject(float deltaTime){
	
    int returnValue=0;

    updatePosition(deltaTime);

    glPushMatrix();		
			
        glNormal3f(0,0,1);
        glColor3f(1,1,1);
		
        glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
        glEnable(GL_BLEND);
		
        glBindTexture(GL_TEXTURE_2D, enemyTexture);
        glEnable(GL_TEXTURE_2D);		
		
        glPushMatrix();		
			
            glTranslatef(position.x, position.y, position.z);
            glBegin(GL_QUADS);
                glTexCoord2f(1,1); glVertex3f(  (boundingSphereRadius/2), (boundingSphereRadius/2),1);
                glTexCoord2f(0,1); glVertex3f( -(boundingSphereRadius/2), (boundingSphereRadius/2),1);
                glTexCoord2f(0,0); glVertex3f( -(boundingSphereRadius/2),-(boundingSphereRadius/2),1);
                glTexCoord2f(1,0); glVertex3f(  (boundingSphereRadius/2),-(boundingSphereRadius/2),1);
            glEnd();

        glPopMatrix();

        glDisable(GL_TEXTURE_2D);		
        glDisable(GL_BLEND);				
		
    glPopMatrix();	
	
    if ( controlCreationEnemyFire(deltaTime) ) 
        //fire ret
        returnValue=1;
    else		
        //fire retme
        returnValue=2;

    //Eer dsman grntden iktiysa ve bonuslu degilse pozisyonu ve sekli yenilensin
    if (position.x < MIN_X  || position.y < MIN_Y || position.y > MAX_Y){
        returnValue=3;
    }
		

    return returnValue;

}