//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "Meteor.h" 


Meteor::Meteor() {
	
    setObjectProperties();	
    newShape();
    
}

void Meteor::setMeteorBonus(bool bonusMeteor) {
		
    bonus=bonusMeteor;
    if (bonus) bonusFinish=false;
	
	
}

void Meteor::newShape(){
	
    bonusTimer = 0;
    
    //tipi retiliyor	
    int a = rand()%3;
    
    switch (a){
	
        case 0: 
            shape = 0;
            boundingSphereRadius =2.5;
            break;
        case 1: 
            shape = 1;
            boundingSphereRadius =2;
            break;
        case 2: 
            shape = 2;
            boundingSphereRadius =1.5;
            break;
    }

}

void Meteor::updatePosition(float deltaTime){
	
    deltaTime *= objectVelocity * 10;

    position.x -= deltaTime;
    position.y += objectDirection * deltaTime * 0.2;

}

int Meteor::renderObject(float deltaTime){

    updatePosition(deltaTime);

    glPushMatrix();

        bonusTimer+=(deltaTime * 2.0f);
	
        glTranslatef(position.x,position.y,position.z);
 
        //Bonusu olan meteorlerin etrafina kirmizi bir texture kaplanyor
        if (bonus){
			
            if (bonusType==OIL_BONUS)
                glColor3f(1,1,0);
            else if (bonusType==HEALTH_BONUS)
                glColor3f(0,1,0);
			
            glBlendFunc(GL_ONE,GL_ONE);
            glEnable(GL_BLEND);
		
            glBindTexture(GL_TEXTURE_2D, bonusTexture);
            glEnable(GL_TEXTURE_2D);		
            glDisable(GL_LIGHTING);
            glBegin(GL_QUADS);
                glTexCoord2f(1,1); glVertex2f( (boundingSphereRadius) + sin(bonusTimer), (boundingSphereRadius)+sin(bonusTimer));
                glTexCoord2f(0,1); glVertex2f(-(boundingSphereRadius) - sin(bonusTimer), (boundingSphereRadius) +sin(bonusTimer));
                glTexCoord2f(0,0); glVertex2f(-(boundingSphereRadius) - sin(bonusTimer),-(boundingSphereRadius) -sin(bonusTimer));
                glTexCoord2f(1,0); glVertex2f( (boundingSphereRadius) + sin(bonusTimer),-(boundingSphereRadius) -sin(bonusTimer));
            glEnd();
            glDisable(GL_TEXTURE_2D);		
            glEnable(GL_LIGHTING);				
        }

        glNormal3f(0,0,1);
        glColor3f(color.x ,color.y ,color.z);

        meteorAnimation.update ( deltaTime * 20 );
        meteorAnimation.RenderAnimation(0,0,boundingSphereRadius);
		
        //Eer meteor grntden iktiysa ve bonuslu degilse pozisyonu ve sekli yenilensin
        if (position.x < MIN_X  || position.y < MIN_Y || position.y >MAX_Y)
            if (!bonus)
                setObjectProperties();
            else{
                bonusFinish=true;			
            }

    glPopMatrix();
	
    return 0;

}

void Meteor::setMeteorSprites(unsigned int *sprites,int size){
	
    for (int i=0;i<size;++i){
        meteorAnimation.PushTextureID(sprites[i]);				
    }
    meteorAnimation.Initialize(ANIMATE_VELOCITY);	

}

void Meteor::setBonusType(int type,unsigned int bonusText){
	
    bonusType=type;
    bonusTexture=bonusText;

}