//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "Ship.h" 

Ship::Ship(){}

Ship::Ship(Vec3d Position,unsigned int shpTexture,unsigned int expTexture){
	
    position = Position;
	
    direction=NONE;

    shipTexture = shpTexture;
    explosionTexture = expTexture;

    damage = 0;
    hitPoint=SHIP_HIT_POINT;
	
    oil= SHIP_OIL;
    meter=0;
    textComeCounter=0;

    shipWidth = SHIP_WIDTH;
    shipHeight = SHIP_HEIGHT;
	
}

void Ship :: updateShip(bool movup,bool movdown,bool movleft,bool movright,float Velocity) {

    const float distance = Velocity *10;
	
    meter += Velocity * 0.1f ;
	
    if (movup)
        position.y +=distance;		
    else if (movdown)
        position.y -=distance;
		
    if (movleft)
        position.x -=distance;		
    else if (movright)
        position.x +=distance;

    if ( position.x+(shipWidth/2) > MAX_X )
        position.x=MAX_X - (shipWidth/2);
	
    if ( position.x-(shipWidth/2) < MIN_X )
        position.x=MIN_X + (shipWidth/2);
		
    if ( position.y + (shipHeight/4)> MAX_Y )
        position.y=MAX_Y - (shipHeight/4);
	
    if ( position.y - (shipHeight/4)< MIN_Y +1 )
        position.y=MIN_Y + 1 + (shipHeight/4);
	
}

void Ship::renderShip(){
	
    glDisable(GL_LIGHTING);
	
	//damage izelgesi	
    glPushMatrix();
		
        glBegin(GL_QUADS);
            glColor3f(0.0f,1.0f,0.0f);
            glVertex2f(MAX_X-1.8f,MIN_Y-3.0f);
            glVertex2f(MAX_X-1.8f,MIN_Y-2.0f);
            glColor3f(0.0f,0.5f,0.0f);
            glVertex2f(MAX_X-hitPoint+damage-1.8f,MIN_Y-2.0f);
            glVertex2f(MAX_X-hitPoint+damage-1.8f,MIN_Y-3.0f);
        glEnd();
        
    glPopMatrix();	

	//benzin izelgesi	
    glPushMatrix();
		
        glBegin(GL_QUADS);
            glColor3f(1.0f,0.0f,0.0f);
            glVertex2f(MAX_X-1.8f,MIN_Y-1.5f);
            glVertex2f(MAX_X-1.8f,MIN_Y-0.5f);
            glColor3f(0.5f,0.0f,0.0f);
            glVertex2f(MAX_X-oil+meter-1.8f,MIN_Y-0.5f);
            glVertex2f(MAX_X-oil+meter-1.8f,MIN_Y-1.5f);
        glEnd();

    glPopMatrix();	
	
    glNormal3f(0.0f,0.0f,-1.0f);
    glColor3f(1.0f,1.0f,1.0f);
	
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);

    glBindTexture(GL_TEXTURE_2D, shipTexture);
    glEnable(GL_TEXTURE_2D);		
	
    glPushMatrix();		
        glBegin(GL_QUADS);
            glTexCoord2f(1.0f,1.0f); glVertex3f(position.x + (shipWidth/2),position.y+(shipHeight/2),1.0f);
            glTexCoord2f(0.0f,1.0f); glVertex3f(position.x - (shipWidth/2),position.y+(shipHeight/2),1.0f);
            glTexCoord2f(0.0f,0.0f); glVertex3f(position.x - (shipWidth/2),position.y-(shipHeight/2),1.0f);
            glTexCoord2f(1.0f,0.0f); glVertex3f(position.x + (shipWidth/2),position.y-(shipHeight/2),1.0f);
        glEnd();
    glPopMatrix();

    glDisable(GL_TEXTURE_2D);		
    glDisable(GL_BLEND);
		
    glEnable(GL_LIGHTING);
	
}

//Geminin hasar almasi durumunda cizdirilen patlama efekti
void Ship::Explosion(int dimension){
	
    float fx,fy;

    fx= (float)((fmod(dimension,4))*0.25f);    
    fy= (float)(1-((dimension/4)*0.25f));
	
    glBindTexture(GL_TEXTURE_2D, explosionTexture);
    glEnable(GL_TEXTURE_2D);		
    glDisable(GL_LIGHTING);
	
    glBlendFunc(GL_ONE,GL_ONE);	
    glEnable(GL_BLEND);	
	
    glBegin(GL_QUADS);
		
        glPushMatrix();		
		
        glColor3f(1.0f,0.5f,0.5f);
        glTexCoord2f(fx,fy-0.25f);		    glVertex3f(position.x-5.0f,position.y-5.0f,1.1f);
        glTexCoord2f(fx+0.25f,fy-0.25F);	glVertex3f(position.x+5.0f,position.y-5.0f,1.1f);
        glTexCoord2f(fx+0.25f,fy);		    glVertex3f(position.x+5.0f,position.y+5.0f,1.1f);
        glTexCoord2f(fx,fy);			    glVertex3f(position.x-5.0f,position.y+5.0f,1.1f);
		
        glPopMatrix();

    glEnd();
	
    glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);	
    glEnable(GL_LIGHTING);
	
}

int Ship::ShipDead (float Velocity){	

    position.y -= Velocity * 10;
	
    if ( position.y < MIN_Y - 15 )
        return 1;

    return 0;

}