//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "EnemyNormal.h"

EnemyNormal::EnemyNormal(float FireCreationTime){
	
    setObjectProperties();	

    boundingSphereRadius = 4.0f;

    fireCreationTime = FireCreationTime;
    fireTimer = 0.0f;

}

void EnemyNormal::configureFireRotation(){
	
    float	distY;
    float	increaseValue = 10;

    fireIncX = (increaseValue) ;
	
    distY = position.y - shipPosition.y ;
	
    if (distY<0)
        fireIncY =-increaseValue;				
    else
        fireIncY = increaseValue;

}
		
//returnValue=1  fire ret
//returnValue=2  fire retme
//returnValue=3  enemy sil
int	EnemyNormal::renderObject(float deltaTime){
	
    int returnValue=0;

    updatePosition(deltaTime);

    glPushMatrix();		
			
        glNormal3f(0.0f,0.0f,1.0f);
        glColor3f(1.0f,1.0f,1.0f);
		
        glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
        glEnable(GL_BLEND);
		
        glBindTexture(GL_TEXTURE_2D, enemyTexture);
        glEnable(GL_TEXTURE_2D);		
		
        glPushMatrix();		
			
            glTranslatef(position.x, position.y, position.z);
            glBegin(GL_QUADS);
                glTexCoord2f(1.0f,1.0f); glVertex3f(  (boundingSphereRadius/2), (boundingSphereRadius/2),1.0f);
                glTexCoord2f(0.0f,1.0f); glVertex3f( -(boundingSphereRadius/2), (boundingSphereRadius/2),1.0f);
                glTexCoord2f(0.0f,0.0f); glVertex3f( -(boundingSphereRadius/2),-(boundingSphereRadius/2),1.0f);
                glTexCoord2f(1.0f,0.0f); glVertex3f(  (boundingSphereRadius/2),-(boundingSphereRadius/2),1.0f);
            glEnd();

        glPopMatrix();

        glDisable(GL_TEXTURE_2D);		
        glDisable(GL_BLEND);				
		
    glPopMatrix();	
	
    if ( controlCreationEnemyFire(deltaTime) ) 
        //fire ret
        returnValue=1;
    else		
        //fire retme
        returnValue=2;

    //Eer dsman grntden iktiysa ve bonuslu degilse pozisyonu ve sekli yenilensin
    if (position.x < MIN_X  || position.y < MIN_Y || position.y > MAX_Y){
        returnValue=3;
    }	

    return returnValue;

}