// glFont source code: copyright by Brad Fish

#include "Font.h"

GLFONT *glFont;

int glFontCreate (GLFONT *Font, char *FileName,int Tex){

    FILE    *fontFile;
    char    *texBytes;
    int     characterCounter;

	//Font dosyasi ailiyor
	if ((fontFile = fopen(FileName, "rb")) == NULL)
		return FALSE;

	//glFont structure okunuyor
	fread(Font, sizeof(GLFONT), 1, fontFile);

	//Texture numarasi aliniyor
	Font->Tex = Tex;

	//Karakter sayisi aliniyor
	characterCounter = Font->IntEnd - Font->IntStart + 1;

	//Alinan karakterler iin bellekte blge ayriliyor
	if ((Font->Char = (GLFONTCHAR *)malloc(
		sizeof(GLFONTCHAR) * characterCounter)) == NULL)
		return FALSE;

	//GlFont karakterleri okunuyor
	fread(Font->Char, sizeof(GLFONTCHAR), characterCounter, fontFile);

	//Texture size hesaplaniyor
	characterCounter = Font->TexWidth * Font->TexHeight * 2;

	//Texture iin bellekten yer aliniyor
	if ((texBytes = (char *)malloc(characterCounter)) == NULL)
		return FALSE;

	//Texture okunuyor
	fread(texBytes, sizeof(char), characterCounter, fontFile);

	//Texture zellikleri ayarlaniyor
	glBindTexture(GL_TEXTURE_2D, Font->Tex);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE,GL_MODULATE);

	//Texture yaratiliyor
	glTexImage2D(GL_TEXTURE_2D, 0, 2, Font->TexWidth,Font->TexHeight, 0, GL_LUMINANCE_ALPHA,GL_UNSIGNED_BYTE, (void *)texBytes);

	free(texBytes);
	fclose(fontFile);

	return TRUE;
}

void glFontDestroy (GLFONT *Font){
	free(Font->Char);
}

void glFontBegin (GLFONT *Font){
	if (Font->Char != NULL)
		glFont = Font;
	else
		glFont = NULL;

	glBindTexture(GL_TEXTURE_2D, Font->Tex);
}

void glFontEnd (void){

	glFont = NULL;
}

void glFontTextOut (char *String, float x, float y, float z){
	int Length, i;
	GLFONTCHAR *Char;

	if (glFont == NULL)
		return;

	Length = strlen(String);
	glBegin(GL_QUADS);

	for (i = 0; i < Length; i++)
	{
		Char = &glFont->Char[(int)String[i] - glFont->IntStart];

		glTexCoord2f(Char->tx1, Char->ty1);
		glVertex3f(x, y, z);
		glTexCoord2f(Char->tx1, Char->ty2);
		glVertex3f(x, y - Char->dy, z);
		glTexCoord2f(Char->tx2, Char->ty2);
		glVertex3f(x + Char->dx, y - Char->dy, z);
		glTexCoord2f(Char->tx2, Char->ty1);
		glVertex3f(x + Char->dx, y, z);

		x += Char->dx;
	}

	glEnd();
}

