//-----------------------------------------------------------------------------------
// Bismillahirrahmanirrahim  
//-----------------------------------------------------------------------------------
//																					|
//               MOS 2D Engine ( MEYDANER OpenGL Software Engine)					|
//																				    |
// ----------------------------------------------------------------------------------
//    Yapimci = Vedat Meydaneri														|
//     email = Chenmy1@yahoo.com													|
//     web = www.turkop.cjb.net														|
//-----------------------------------------------------------------------------------
// MOS 2D Engine (Vedat Meydaneri ) - Olusturma tarihi :10/ Temmuz /2003 saat: 15:00 |
//************************************************************************************
//************************************************************************************
//************************************************************************************
//------------------------------------------------------------------------------------  

#include "mosfps.h"


MOSFps::MOSFps(void)
{

}
MOSFps::~MOSFps(void)
{

}
struct
{
  __int64       frequency;          // Timer Frequency
  GLdouble            resolution;          // Timer Resolution
  unsigned long mm_timer_start;     
  
  // Multimedia Timer Start Value
  unsigned long mm_timer_elapsed;      // Multimedia Timer Elapsed Time
  bool   performance_timer;    
  
  // Using The Performance Timer?
  __int64       performance_timer_start;      // Performance Timer Start Value
  __int64       performance_timer_elapsed; // Performance Timer Elapsed Time
} timer;
// Initialize Our Timer
inline void MOSFps::TimerInit(void)
{
     memset(&timer, 0, sizeof(timer));   
 // Clear Our Timer Structure
     // Check To See If A Performance Counter Is Available
     // If One Is Available The Timer Frequency Will Be Updated
     if (!QueryPerformanceFrequency((LARGE_INTEGER *) &timer.frequency))
     {
          // No Performace Counter Available
          timer.performance_timer = FALSE;                      // Set Performance Timer To FALSE
          timer.mm_timer_start = timeGetTime();                 // Use timeGetTime()
          timer.resolution  = 1.0f/1000.0f;                           // Set Our Timer Resolution To .001f
          timer.frequency   = 1000;                                     // Set Our Timer Frequency To 1000
          timer.mm_timer_elapsed = timer.mm_timer_start; // Set The Elapsed Time
     }
     else
     {
          // Performance Counter Is Available, Use It Instead Of The Multimedia Timer
          // Get The Current Time And Store It In performance_timer_start
          QueryPerformanceCounter((LARGE_INTEGER *) &timer.performance_timer_start);
          timer.performance_timer   = TRUE;    // Set Performance Timer To TRUE
          // Calculate The Timer Resolution Using The Timer Frequency
          timer.resolution    = (GLdouble) (((double)1.0f)/((double)timer.frequency));
          // Set The Elapsed Time To The Current Time
          timer.performance_timer_elapsed = timer.performance_timer_start;
     }
}
inline GLfloat MOSFps::ABS(GLfloat A)
{
  if (A < 0)
    return -A;
  else 
    return A;
}
bool MOSFps::OlusturTimer()
{
	  TimerInit(); 
	Time1 = TimerGetTime()/1000;
    Time2 = TimerGetTime()/1000;

	return TRUE;
}
void MOSFps::FPSKisitla(int fps)
{
if(fps == FPS_ATMIS)
{
  Time2 = TimerGetTime()/1000;
  while (ABS(Time2-Time1) < .015f) // .015f == 66 frames per second, .01f == 100 frames per second
  { 
    Time2 = TimerGetTime()/1000; 
  } 	  
  Time1 = TimerGetTime()/1000;
}else if(fps == FPS_YUZ)
{
  Time2 = TimerGetTime()/1000;
  while (ABS(Time2-Time1) < .01f) // .015f == 66 frames per second, .01f == 100 frames per second
  { 
    Time2 = TimerGetTime()/1000; 
  } 	  
  Time1 = TimerGetTime()/1000;
}else if(fps==FPS_OTUZ)
{
   Time2 = TimerGetTime()/1000;
  while (ABS(Time2-Time1) < .03f) // .015f == 66 frames per second, .01f == 100 frames per second
  { 
    Time2 = TimerGetTime()/1000; 
  } 	  
  Time1 = TimerGetTime()/1000;
}
else
{ 
	Time2 = TimerGetTime()/1000;
  while (ABS(Time2-Time1) < .015f) // .015f == 66 frames per second, .01f == 100 frames per second
  { 
    Time2 = TimerGetTime()/1000; 
  } 	  
  Time1 = TimerGetTime()/1000;

}

}
// Get Time In Milliseconds
inline GLdouble MOSFps::TimerGetTime()
{
     __int64 time;                                  // 'time' Will Hold A 64 Bit Integer
     if (timer.performance_timer)           // Are We Using The Performance Timer?
     {
          QueryPerformanceCounter((LARGE_INTEGER *) &time); // Current Performance Time
          // Return The Time Elapsed since TimerInit was called
          return ( (GLdouble) ( time - timer.performance_timer_start) * timer.resolution)*1000.0f;
     }
     else
     {
          // Return The Time Elapsed since TimerInit was called
          return ( (GLdouble) ( timeGetTime() - timer.mm_timer_start) * timer.resolution)*1000.0f;
     }
}


