////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#ifndef __head_h__
#define __head_h__

#pragma warning (disable : 4786)

#include "MovingObject.h"

#include <lib3d/util2d/Particle.h>
#include <lib3d/model/loader/MSAsciiLoader.h>
#include <lib3d/util2d/Billboard.h>

// Oyundaki baslica dusmanlarimizi olusturan sinif.
// MovingObject sinifindan turuyor ve bu sinifin waypointe gore hareket etme
// ozelligini kullaniyor. Tum cizim islemleri render() fonksiyonunda hallediliyor.
// update() fonksiyonunda ise Head nesnesinin zamana gore cesitli durumlara gecisi
// gerceklestiriliyor. Ilk durum yaratildiktan sonra yeryuzune cikmasi, daha sonra
// hedefe dogru ilerlemeye basliyor, hedefe ulastiginda ise olu duruma geciyor.

class Head : public MovingObject {

public:

   enum eHeadState { HS_DEPLOYING=0, HS_MOVING, HS_DYING, HS_STOPPED, HS_ATTARGET };
   enum eHeadType  { HT_BONES=0, HT_GREEN, HT_BLACK, HT_AVOIDMAN };

   Head();
   ~Head();

   eHeadState getState()   { return state; };
   void     setType(eHeadType s)   { headtype = s; };
   eHeadType getType()   { return headtype; };
   void     setState(eHeadState s)   { state = s; };
   void     enableParticles(bool e) { enablePart = e; };
   
   void init();
   void update(float dt);
   void render();
   void renderSilhouette();    // for stencil shadows..
   void onWaypoint(int idx);

protected:

   eHeadState state;
   eHeadType  headtype;
   float heading_angle;
   bool  enablePart;
   float dead_start_time;
   
   Particle *pengine;
   
   static bool first_init;
   static Model *model;
   static Billboard *bb;
   

};

#endif