////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt) !! FMOD excluded!!!
//            visit www.fmod.org for FMOD license!
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#ifndef __SoundManager_h__
#define __SoundManager_h__

#include <stdio.h>
#include <stdlib.h>
#if defined(WIN32) || defined(_WIN64) || defined(__WATCOMC__)
    #include <windows.h>
    #include <conio.h>
#else
    #include <wincompat.h>
#endif

#include <fmod.h>
#include <fmod_errors.h>

#include <list>

struct sFadeSound {
   int   channel;
   int   targetvol;
   float speed;
   float f_vol;
   int   signval;
};

typedef std::list<sFadeSound> FadeSoundList;

enum SampleID {
   SAM_AMBIANCE=0, SAM_PAIN1, SAM_PAIN2, SAM_PAIN3, SAM_PAIN4, SAM_PAIN5, SAM_INGAMEBACKGROUND, SAM_MENUBACKGROUND,
   SAM_MOANER1,SAM_MOANER2,SAM_MOANER3,SAM_MOANER4,
   SAM_BUILD_TRAP1,SAM_BUILD_TRAP2,SAM_BUILD_TRAP3,
   SAM_SKULL_TRAPPED, SAM_DESTROYER_BONUS, SAM_HEALTH_BONUS,SAM_MENU_MOVE,
   SAM_INTRO_SPEAK, SAM_END_SPEAK,
   SAM_DEATH1,
   SAM_LAST
};

// Bu sinif ses ile ilgili tum islemleri gerceklestirmekten sorumlu.
// init() fonksiyonu icerisinde sisteme yuklenen ses dosyalarini
// playXXX() yordamlari ile caldirabiliyorsunuz. Ayni zamanda ses seviyesini
// ayarlama, sesi kisma gibi bazi alt seviye fonksiyonlarda destekleniyor.

class SoundManager {

public:
   SoundManager();
   ~SoundManager();

   void init();
   void destroy();
   void update(float dt);
   int  playSample(int sid,int channel=FSOUND_FREE,bool looped=false);
   void mute(bool m) { mutesnd = m; };
   void setMasterVolume(unsigned char mvol);
   
   void startInGameBackgroundSound();
   void stopInGameBackgroundSound();
   void startMenuBackgroundSound();
   void stopMenuBackgroundSound();
   void playRandomMoaner();
   void playPlayerPain();
   void playPlayerDeath();
   void playBuildTrap();
   void playSkullTrapped();
   void playDestroyerBonusTaken();
   void playHealthBonusTaken();
   void playMenuMove();
   void playBeginGameSpeech();
   void playEndGameSpeech();

protected:

   void fadeSound(int channel,int fromvol,int tovol,float speed);

   FSOUND_SAMPLE *samples[SAM_LAST];
   FadeSoundList fadeList;

   bool playing_ingamebackground;
   bool playing_menubackground;
   int  ingamebackground_channel;
   int  menubackground_channel;

   bool mutesnd;
   unsigned char maxvolume;


};


#endif