////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#ifndef __TARGET_H__
#define __TARGET_H__

#pragma warning (disable : 4786)

#include <lib3d/lib3d.h>
#include <lib3d/util2d/Texture.h>
#include <lib3d/util3d/Position3d.h>

// Bu sinif mouse ile kontrol edilen hedef sembolunu olusturmak icin kullaniliyor.
// Kendi icinde hedef sembolunun pozisyonunu tutuyor. render() ile bunu ekrana ciziyor.
// updateMouseCoordinates() fonksiyonu app sinifi icerisinden cagirilarak Target
// nesnesine mouse daki degisimi gonderiyor, bu degisime gore target sembolunun
// pozisyonu degistiriliyor.

class Target {

public:

   Target();
   ~Target();

   void  setSpeed(float spd);
   void  setScale(float s);
   float getScale();
   void  setLocked(bool b);
   bool  getLocked();
   Vector3d getPosition() { return location.pos; };
   void  updateMouseCoordinates(int deltax,int deltay);
      
   Vector3d getBoundingBox();
   float    getBoundingSphere();

   void render();


private:

   Position3d location;
   float      speed;
   float      tscale;
   bool       locked;

};


#endif