#pragma warning (disable : 4786)

#ifndef __BaseApp_h__
#define __BaseApp_h__

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

#include <gl/gl.h>
#include <gl/glu.h>
#include <sdl/sdl.h>

#include <lib3d/lib3d.h>
#include <lib3d/util3d/Camera.h>

typedef enum eProjectionType { PROJ_ORTHO=0, PROJ_PERSPECTIVE };

class BaseApp {

public:
   BaseApp();
   virtual ~BaseApp() {};

   void setSize(int w,int h);                // sets window widht & height. Call it before start()!
   void setTitle(const char *title);         // sets window caption
   void setColorBits(int bpp);               // sets colorbits (eg .16,24,32). Call it before start()!
   void setFullScreen(bool enable);          // enable fullscreen mode. Call it before start()!
   void setPerspectiveParams(float vfov,float neard,float fard);  // sets perspective projection parameters
   void setOrthoParams(float left,float right,float bottom,float top);  //sets orthographic projection parameters
   void setProjection(eProjectionType proj);        // sets projection type (eg PROJ_ORTHO or PROJ_PERSPECTIVE
   void setVideoFlags(int flagbits);         // set additional SDL_ video flags. these are used by SDL_SetVideoMode(...)
   void showFPS(bool enable);                // enable or disable FPS rendering on window caption
   unsigned int getFPS();                    // get current fps
   void enableSimpleCamera(bool enable);     // enables or disable simple camera usage
   void applySimpleCamera();                 // apply simple camera transformations. Must be called on top of onRender() func.
   void setSimpleCameraSpeed(float spd);     // sets simpel camera speed factor
   
   void start();                             // initialize and start the framework. Begin event loop..
   
   // Event functions. These should be overridden by derived class
   virtual void onInit() {}        // called only once, before entering rendering loop
   virtual void onExit() {};       // called when exiting from the application
   virtual void onKeyPressed(const SDLKey &key) {};       // called when a key is pressed
   virtual void onKeyReleased(const SDLKey &key) {};      // called when a key is released
   virtual void onMouseButtonPressed(int button,int scrx,int scry) {};   // called when mouse button is pressed
   virtual void onMouseButtonReleased(int button,int scrx,int scry) {};  // called when mouse button is released
   virtual void onWindowResize(int w,int h);    // called when window is resized
   virtual void onEvent(const SDL_Event &event) {};  // called whenever an unnamed event occurs
   
   // this function must be implemented in derived class
   virtual void onRender() = 0;     // all opengl rendering should occur here.

protected:

   Camera simpleCamera;
   
   void exit();              // should be called within derived class to exit

private:

   void initVideo();
   void initOpenGL();
   void updateSimpleCamera(const SDLKey &key,bool pressed);
   void moveSimpleCamera();
   void run();
   
   bool  quit_app;
   int   width,height,bpp;
   bool  fullScreen;
   bool  video_initialized;
   bool  show_fps;
   int   videoFlags;
   float fov,neard,fard;
   float left,right,top,bottom;
   eProjectionType projType;
   char  windowTitle[256];
   
   float simple_camera_speed;
   bool  use_simple_camera;
   bool  simple_cam_forw,simple_cam_back,simple_cam_tleft,simple_cam_tright;
   bool  simple_cam_up,simple_cam_down,simple_cam_tup,simple_cam_tdown;
      
   unsigned int frameCount;
   unsigned int framesPerSecond;
   unsigned int lastTime;

};


#endif