#ifndef __MSASCIILOADER_H__
#define __MSASCIILOADER_H__

#pragma warning (disable : 4786)

#include <stdio.h>
#include <string.h>
#include <lib3d/model/model.h>

struct tVertexData {
   float x,y,z,u,v;
};

struct tNormalData {
   float x,y,z;
};

struct tFaceData {
   int v1,v2,v3,n1,n2,n3;
};

struct tMatProp {
   ColorVec amb,dif,spe,emi;
   float var1, var2;
   char texName1[256];
   char texName2[256];
};



class MSAsciiLoader {

private:
   MSAsciiLoader();

public:
   ~MSAsciiLoader();

   Model* load(char *path);
   static MSAsciiLoader* instance();

protected:

   void skipLine();
   int  readMeshCount();
   void readMeshName(char *name);
   int  readInt();
   float readFloat();
   void readVertexData(tVertexData *vd);
   void readNormalData(tNormalData *nd);
   void readFaceData(tFaceData *fd);
   int  readMaterialCount();
   void readMaterialName(char *name);
   void readMaterialPath(char *path);
   void readMaterialProperty(tMatProp *mp);
   void readString(char *str);
   int  readMeshName_materialIndex(char *meshName);

   void readLine(char *line);

   FILE *fp;

};




#endif