#pragma warning (disable : 4786)

#ifndef __MODEL_H__
#define __MODEL_H__

#include <lib3d/model/modeltypes.h>
#include <lib3d/util3d/Vector3d.h>


class Model {

public:
      
   friend class AnimatedModel;

   Model();
   virtual ~Model();

   void build();
   Vector3d getBoundingBox(int meshnum);
   Vector3d getBoundingBox();
   float    getBoundingSphere(int meshnum);
   float    getBoundingSphere();
      
   void setMeshes(tMesh *meshes,int count);
   void setMaterials(tMaterial *materials,int count);
   void setPath(const char *path);
   const char* getPath();

   virtual void render();
   
protected:

   void render_textured(tMesh *mesh,Texture *texture) const;
   void render_untextured(tMesh *mesh) const;

   tMesh     *meshes;
   tMaterial *materials;
   int       meshCount;
   int       materialCount;
   char      path[256];

};


#endif