#ifndef __PROPREADER_H__
#define __PROPREADER_H__

// disable some warnings about map<string,string> declaretion..
#pragma warning(disable:4786)    

#include <stdio.h>
#include <stdlib.h>

#include <map>
#include <string>

#define MAX_KEY_LEN              256
#define MAX_VALUE_LEN    MAX_KEY_LEN

#define FILE_NOT_FOUND           1
#define ILLEGAL_ARGUMENT_IN_FILE 2

typedef std::map<std::string,std::string> StrStrMap;

class PropReader {

public:

   PropReader(const char *path);
   ~PropReader() {};

   void  getString(const char *name,char *value);
   int   getInt(const char *name);
   float getFloat(const char *name);
   int   getError();
   
private:

   FILE *fp;
   int  err;
   StrStrMap table;

};

#endif