////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#ifndef __DestroyerBonus_h__
#define __DestroyerBonus_h__

#pragma warning (disable : 4786)

#include "MovingObject.h"
#include <lib3d/util2d/Particle.h>
#include <lib3d/model/loader/MSAsciiLoader.h>
#include <lib3d/util2d/Billboard.h>

#define MAX_DTARGET_COUNT 20

// MovingObject den tureyen bir bonus sinifidir.
// Hareket ozelligine sahip degil. updated() icerisinde cesitli durumlari
// arasinda gecis yapiyor. render() ile ekrana ciziliyor.
// kendi icerisinde bulunan basit bir particle engine de sahip.
// addDestroyerTarget() yordami ile bu bonus alindiginda yok etmeyi saglayacagi
// hedefler belirtilebiliyor. Aslinda direk olarak hedefleri yok etmiyor, aktif
// hale gecince hedefler uzerinde ates efekti olusturuyor.

class DestroyerBonus : public MovingObject {

public:
   
   enum eDestroyerBonusState { DBS_DEACTIVATED=0, DBS_ACTIVATED, DBS_FINISHED };

   DestroyerBonus();

   void addDestroyTarget(const Vector3d &tpos) {
      if (dtarget_cnt < MAX_DTARGET_COUNT) {
         targetPos[dtarget_cnt++] = tpos;
         activation_time = dtime;
      }
   }

   eDestroyerBonusState getState() { return dbstate; }
   void setState(eDestroyerBonusState s) { dbstate = s; };
   
   virtual void init();
   virtual void update(float dt);
   virtual void render();

protected:
   
   eDestroyerBonusState dbstate;
   Vector3d targetPos[MAX_DTARGET_COUNT];
   int dtarget_cnt;
   float activation_time;
   
   static bool first_init;
   static Model *model;
   static Billboard *billboard;

   Particle *pengine;
   

};


#endif