////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#include "HealthBonus.h"

bool   HealthBonus::first_init = true;
Model* HealthBonus::model = NULL;

HealthBonus :: HealthBonus() {
   motype = MOT_HBONUS;
}

void HealthBonus::init() {

   MovingObject::init();
   
   if (HealthBonus::first_init) {      
      HealthBonus::model = MSAsciiLoader::instance()->load("data/powerup1.txt");
      HealthBonus::model->build();
      HealthBonus::first_init = false;
   }

   pengine = new Particle(100);
   Texture *ptex = new Texture("data/particle.tga");
   ptex->build();
   pengine->setTexture(ptex);

   const float particleWidth = 1.0f * 0.2f;
   const float particleLength = particleWidth;
   Vector3d center(0.0f,5.0f,0.0f);
   Vector3d minVel(-particleWidth,-particleWidth,-particleWidth);
   Vector3d maxVel(particleWidth,particleLength,particleWidth);
   Vector3d minAcc(0.0f,0.0f,0.0f);
   Vector3d maxAcc(0.0f,0.0f,0.0f);
   
   pengine->setParameters(center,maxVel,minVel,maxAcc,minAcc,0.1f);
   pengine->addRandomEntities(100,center,maxVel,minVel,maxAcc,minAcc,0.1f);
   for (int i=0;i<100;++i) {
      pengine->setColor(i,i,1,1);
   }

   pengine->setFountain(true);

   speed = 0;
   MovingObject::setState(MovingObject::MOS_WAITINGWP);
   hbstate = HBS_DEACTIVATED;

}

void HealthBonus::update(float dt) {

   MovingObject::update(dt);
   pengine->update(dt);

   if (hbstate == HBS_ACTIVATED) {
      float dt = dtime - activation_time;
      if (dt > 4)
         hbstate = HBS_FINISHED;
   }

}

void HealthBonus::render() {
   
   float dt;
   if (hbstate == HBS_ACTIVATED)
      dt = dtime - activation_time;
   else
      dt = 0;

   glPushMatrix();
   glTranslatef(pos.x,pos.y-dt*5,pos.z);
   //glRotatef(90,1,0,0);
   //glRotatef(90,0,0,1);
   glDisable(GL_LIGHTING);
   glDisable(GL_FOG);
   glEnable(GL_BLEND);
   glBlendFunc(GL_ONE,GL_ONE);
   model->render();
   pengine->render();
   glDisable(GL_BLEND);
   glEnable(GL_LIGHTING);
   glEnable(GL_FOG);
   glPopMatrix();
}

