////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#if !defined(HIGHRESTIMER_H_INCLUDED_)
#define HIGHRESTIMER_H_INCLUDED_

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

// Standart yuksek cozunurluklu windows timer sinifi.
// Windows ortaminda elde edilebilecek en yuksek cozunurluge sahip
// zamanlama fonksiyonelligi sagliyor. Oyun icerisinde zamanin akisini
// sorgulamak icin kullaniliyor.

class HighResTimer {

public:
   
   HighResTimer() {
            
      if (m_llFrequency == 0) {
         LARGE_INTEGER  liFrequency;

         QueryPerformanceFrequency(&liFrequency);
         m_llFrequency = liFrequency.QuadPart;
      }
      
   }

   virtual ~HighResTimer() {}

   // start timer
   void start() {
      QueryPerformanceCounter(&m_llCounter);
   }

   // return elapsed seconds since the last start() operation called..
   double elapsed() {
      LARGE_INTEGER  liNow;
      QueryPerformanceCounter(&liNow);
      return (double)(liNow.QuadPart - m_llCounter.QuadPart)/m_llFrequency;
   }

   

protected:

   LARGE_INTEGER  m_llCounter;

   static LONGLONG   m_llFrequency;

};


#endif


