////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////


#include "MovingObject.h"

MovingObject::MovingObject() {
   recalc = true;
   radius = 10.0f;
   speed = 1.0f;
   dtime = 0;
   curr_target_idx = -1;
   mostate = MOS_WAITINGWP;
   motype = MOT_UNKNOWN;
}

MovingObject::~MovingObject() {
   wpVec.clear();
}

void MovingObject::init() {
}

void MovingObject :: addWaypoint(const Vector3d wp) {
   wpVec.push_back(wp);
   if (mostate == MOS_WAITINGWP) {
      ++curr_target_idx;
      mostate = MOS_MOVING;
   }
}

void MovingObject :: insertWaypoint(const Vector3d wp) {
   if (curr_target_idx > -1) {
      wpVec.push_back(wpVec[wpVec.size()-1]);
      for (int i=wpVec.size()-1;i>curr_target_idx;--i) {
         wpVec[i] = wpVec[i-1];
      }
      wpVec[curr_target_idx] = wp;
   }
   else
      addWaypoint(wp);
}

void MovingObject::update(float dt) {
   
   dtime += dt;
   
   if (mostate == MOS_MOVING) {
      moveToTarget(dt);
   }
   
}

void MovingObject::moveToTarget(float dt) {

   Vector3d currtarget = wpVec[curr_target_idx];
   Vector3d dir(currtarget.x-pos.x,currtarget.y-pos.y,currtarget.z-pos.z);

   Vector3d first = dir;
   dir.normalize();          

   float spd = 0.5f * dt * 500 * speed;
   pos.add(dir.x * spd,dir.y * spd,dir.z * spd);

   Vector3d last(currtarget.x-pos.x,currtarget.y-pos.y,currtarget.z-pos.z);
   Vector3d sum(first.x+last.x,first.y+last.y,first.z+last.z);
   
   float maxlen = max(first.length(),last.length());
   if (sum.length() <= maxlen) {
      
      ++curr_target_idx;
      if (curr_target_idx >= wpVec.size()) {
         mostate = MOS_WAITINGWP;
         speed = 0;
         --curr_target_idx;
      }

      onWaypoint(curr_target_idx-1);

   }

}

bool MovingObject::checkCollision(const Vector3d &tpos,float r) {
   float dx = pos.x - tpos.x;
   float dy = pos.y - tpos.y;
   float dz = pos.z - tpos.z;
   dx *= dx;
   dy *= dy;
   dz *= dz;
   float rsqr = r+radius;
   rsqr *= rsqr;
   if ((dx+dy+dz) > rsqr)
      return false;
   else
      return true;
}

void MovingObject::recalculateDeltaVector() {
   if (curr_target_idx > -1) {
      Vector3d target = wpVec[curr_target_idx];
      delta_vec.x = target.x - pos.x;
      delta_vec.y = target.y - pos.y;
      delta_vec.z = target.z - pos.z;
   }
}




