////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#ifndef __MovingObject_h__
#define __MovingObject_h__

#include <lib3d/util3d/Vector3d.h>

#include <vector>
typedef std::vector<Vector3d> WaypointVector;

#ifndef max
#define max(x,y) (x>y?x:y);
#endif

// Bu sinif oyunda cizilebilecek, bir pozisyonu olan, carpismalara girebilen
// ve cesitli waypointler arasinda hareket kabiliyetine sahip bir nesneyi
// belirtmekte kullanilir.
//
// Bu siniftan tureyen diger siniflarin ozellikle render() fonksiyonunu
// gerceklestirmeleri ve bu fonksiyonda goruntulerini cizmeleri gerekmektedir. 
//
// Yine bu sinifta basit durum kontrolu ozelligi bulunur. MovingObject kendi icinde
// bulundugu duruma gore farkli durumlara gecisi gerceklestirir. Bu islem tureyen
// siniflar tarafindan denetlenmek zorundadir.
//
// Oyunda Head ve Bonus siniflari bu siniftan turemektedir.

class MovingObject {

public:

   enum eMovingObjectType  { MOT_UNKNOWN=0, MOT_HEAD, MOT_HBONUS, MOT_DBONUS };
   enum eMovingObjectState { MOS_MOVING=0, MOS_WAITINGWP };

   MovingObject();
   ~MovingObject();

   void     setPos(const Vector3d &p)   { pos = p; recalc = true; };
   Vector3d getPos()   { return pos; };
   void     setTarget(const Vector3d t) { wpVec.clear(); addWaypoint(t); curr_target_idx = 0; };
   Vector3d getTarget()   { if (curr_target_idx>=0) return wpVec[curr_target_idx]; else return Vector3d(0,0,0); };
   eMovingObjectState getState()   { return mostate; };
   void     setState(eMovingObjectState s)   { mostate = s; };
   eMovingObjectType getType()   { return motype; };
   void     setSpeed(float s)   { speed = s; };
   float    getSpeed()   { return speed; };
   bool     checkCollision(const Vector3d &pos,float r);
   void     addWaypoint(const Vector3d wp);
   void     insertWaypoint(const Vector3d wp);
   
   virtual void init();
   virtual void update(float dt);
   virtual void render() = 0;
   virtual void onWaypoint(int idx) {};

protected:

   void recalculateDeltaVector();
   void moveToTarget(float dt);

   eMovingObjectState mostate;
   eMovingObjectType  motype;
   WaypointVector wpVec;
   float speed;
   Vector3d pos;
   int curr_target_idx;
   Vector3d delta_vec;
   bool recalc;
   float radius;
   float dtime;


   
};



#endif