////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt) !! FMOD excluded!!!
//            visit www.fmod.org for FMOD license!
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#include "SoundManager.h"

SoundManager :: SoundManager() {
   playing_menubackground = false;
   playing_ingamebackground = false;
   mute(false);
   maxvolume = 255;
}

SoundManager :: ~SoundManager() {
}

void SoundManager :: init() {

   if (FSOUND_GetVersion() < FMOD_VERSION) {
      printf("Error : You are using the wrong DLL version!  You should be using FMOD %.02f\n", FMOD_VERSION);
      exit(1);
   }
    
   if (!FSOUND_Init(44100, 32, 0)) {
      printf("%s\n", FMOD_ErrorString(FSOUND_GetError()));
      exit(1);
   }

   samples[SAM_AMBIANCE] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/loop_ambientroom_07.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);
   samples[SAM_PAIN1] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/pain_01.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_PAIN2] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/pain_02.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_PAIN3] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/pain_03.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_PAIN4] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/pain_04.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_PAIN5] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/pain_05.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_INGAMEBACKGROUND] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/loop_ambientroom_07.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_MENUBACKGROUND] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/loop_flames_03.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_MOANER1] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/moaner_01.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_MOANER2] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/moaner_02.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_MOANER3] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/moaner_03.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_MOANER4] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/moaner_04.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_DEATH1] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/death_01.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_BUILD_TRAP1] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/windrush.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_BUILD_TRAP2] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/1shot_nosound_2.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_BUILD_TRAP3] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/1shot_nosound_3.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_SKULL_TRAPPED] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/bsplat_11.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);  
   samples[SAM_DESTROYER_BONUS] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/st_flamesting.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);     
   samples[SAM_HEALTH_BONUS] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/pickup_adrenaline.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);     
   samples[SAM_MENU_MOVE] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/clip_pickup_small.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);
   samples[SAM_INTRO_SPEAK] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/bet_suffering_and_pain_awaits_you.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);
   samples[SAM_END_SPEAK] = FSOUND_Sample_Load(FSOUND_UNMANAGED, "data/bet_death_will_not_be_your_end.ogg", FSOUND_NORMAL | FSOUND_HW2D, 0, 0);

   for (int i=0;i<SAM_LAST;++i) {
      if (!samples[i]) {
         printf("%s\n", FMOD_ErrorString(FSOUND_GetError()));
         exit(1);
      }
   }
   
}

void SoundManager :: destroy() {
   for (int i=0;i<SAM_LAST;++i)
      FSOUND_Sample_Free(samples[i]);

   FSOUND_Close();
}

void SoundManager :: update(float dt) {

   FadeSoundList::iterator i = fadeList.begin();
   while (i != fadeList.end()) {
      sFadeSound &fs = *i;
      if ((fs.signval > 0 && fs.f_vol < fs.targetvol) || (fs.signval < 0 && fs.f_vol > fs.targetvol)) {
         fs.f_vol += fs.signval * fs.speed * dt;
         FSOUND_SetVolume(fs.channel,fs.f_vol);
         ++i;
      }
      else {
         FadeSoundList::iterator crri = i;
         ++i;
         fadeList.erase(crri);
         FSOUND_StopSound(ingamebackground_channel);
      }
   }

}

void SoundManager :: setMasterVolume(unsigned char mvol) {
   FSOUND_SetSFXMasterVolume(mvol);
   maxvolume = mvol;
}

int SoundManager :: playSample(int sid,int channel,bool looped) {
   int m_channel = -1;
   if (mutesnd == false && (sid >= 0 && sid < SAM_LAST)) {
      m_channel = FSOUND_PlaySoundEx(channel,samples[sid],NULL,true);
      if (looped)
         FSOUND_SetLoopMode(m_channel,FSOUND_LOOP_NORMAL);
      FSOUND_SetPaused(m_channel,false);
   }
   setMasterVolume(maxvolume);
   return m_channel;
}

void SoundManager :: fadeSound(int channel,int fromvol,int tovol,float speed) {

   sFadeSound fs;
   fs.channel = channel;
   fs.targetvol = tovol;
   fs.speed = speed;
   fs.f_vol = fromvol;
   
   fs.signval = (tovol > fs.f_vol) ? 1 : -1;

   fadeList.push_back(fs);

}

void SoundManager :: startInGameBackgroundSound() {
   if (playing_ingamebackground)
      stopInGameBackgroundSound();

   ingamebackground_channel = playSample(SAM_INGAMEBACKGROUND,FSOUND_FREE,true);
   playing_ingamebackground = true;
}

void SoundManager :: stopInGameBackgroundSound() {
   if (playing_ingamebackground) {
      playing_ingamebackground = false;
      FSOUND_StopSound(ingamebackground_channel);
   }
}

void SoundManager :: startMenuBackgroundSound() {
   if (playing_menubackground)
      stopMenuBackgroundSound();

   menubackground_channel = playSample(SAM_MENUBACKGROUND,FSOUND_FREE,true);
   fadeSound(menubackground_channel,0,maxvolume,80.0f);
   playing_menubackground = true;
}

void SoundManager :: stopMenuBackgroundSound() {
   if (playing_menubackground) {
      playing_menubackground = false;
      fadeSound(menubackground_channel,maxvolume,0,80.0f);
   }
}

void SoundManager :: playRandomMoaner() {
   const int randomness = 300;
   
   if (rand()%randomness == 0) {
      playSample(SAM_MOANER1+(rand()%4));
   }

}

void SoundManager :: playPlayerDeath() {
   playSample(SAM_DEATH1);
}

void SoundManager :: playPlayerPain() {
   playSample(SAM_PAIN1+(rand()%5));
}

void SoundManager :: playBuildTrap() {
   playSample(SAM_BUILD_TRAP1);
}

void SoundManager :: playSkullTrapped() {
   playSample(SAM_SKULL_TRAPPED);
}

void SoundManager :: playDestroyerBonusTaken() {
   playSample(SAM_DESTROYER_BONUS);
}

void SoundManager :: playHealthBonusTaken() {
   playSample(SAM_HEALTH_BONUS);
}

void SoundManager :: playMenuMove() {
   playSample(SAM_MENU_MOVE);
}

void SoundManager :: playBeginGameSpeech() {
   playSample(SAM_INTRO_SPEAK);
}

void SoundManager :: playEndGameSpeech() {
   playSample(SAM_END_SPEAK);
}


