////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#include "Trap.h"


bool   Trap::first_init = true;
Model* Trap::model = NULL;
Model* Trap::model2 = NULL;

Trap::Trap(float life_timet) {
   life_time = life_timet;
}

Trap::~Trap() {
   delete pengine;
}

void Trap::init() {

   if (Trap::first_init) {      
      Trap::model = MSAsciiLoader::instance()->load("data/Trap.txt");
      Trap::model->build();
      Trap::model2 = MSAsciiLoader::instance()->load("data/Trap3.txt");
      Trap::model2->build();
      Trap::first_init = false;
   }

   pengine = new Particle(100);
   Texture *ptex = new Texture("data/particle.tga");
   ptex->enableMipmapping(false);
   ptex->build();
   pengine->setTexture(ptex);

   const float particleWidth = 1.0f * 0.2f;
   const float particleLength = 0.5f * 0.2f;
   Vector3d center(0.0f,-10.0f,0.0f);
   Vector3d minVel(-particleWidth,0.10f,-particleWidth);
   Vector3d maxVel(particleWidth,2*particleLength,particleWidth);
   Vector3d minAcc(0.0f,0.0f,0.0f);
   Vector3d maxAcc(0.0f,0.0f,0.0f);
   
   pengine->setParameters(center,maxVel,minVel,maxAcc,minAcc,0.1f);
   pengine->addRandomEntities(100,center,maxVel,minVel,maxAcc,minAcc,0.1f);
   for (int i=0;i<100;++i) {
      pengine->setColor(i,i,1,1);
   }

   pengine->setFountain(true);
   state = TS_DEPLOYING;
   time = 0;

}

void Trap::update(float dt) {
   pengine->update(dt);
   
   if (state == TS_DEPLOYING) {
      pos.y += dt * 5000.0f;     // quick hack for no deployment!
      if (pos.y >= 0) {
         pos.y = 0;
         //pos.y += (rand()%10/100);
         state = TS_ACTIVE;
      }
   }
   else
   if (state == TS_ACTIVE) {
      time += dt;
      if (time > life_time)
         state = TS_PASSIVE;
   }
}

void Trap::render() {

   glDisable(GL_FOG);
   glEnable(GL_BLEND);
   glDisable(GL_CULL_FACE);
   glDisable(GL_DEPTH_TEST);
   
   float scale_sin = ((sin(2*time)+1)/4)+1;
   
   glPushMatrix();
   glTranslatef(pos.x,pos.y,pos.z);
   glBlendFunc(GL_ONE_MINUS_SRC_ALPHA,GL_ONE);
   //model->render();
   glPushMatrix();
   glScalef(scale_sin,1,scale_sin);
   glColor3f(0.8f,0.8f,1.0f);
   glBlendFunc(GL_ONE,GL_ONE);
   model2->render();
   glPopMatrix();
   glTranslatef(0,5,0);
   glScalef(2,2,2);
   pengine->render();
   glPopMatrix();

   glDisable(GL_BLEND);
   glEnable(GL_CULL_FACE);
   glEnable(GL_FOG);
   glEnable(GL_DEPTH_TEST);

}



