////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#ifndef __trap_h__
#define __trap_h__

#pragma warning (disable : 4786)

#include <lib3d/util3d/Vector3d.h>
#include <lib3d/util2d/Particle.h>
#include <lib3d/model/loader/MSAsciiLoader.h>

// Bu sinif ile bir kapan nesnesinin goruntulenmesi saglaniyor.
// render() icerisinde kapanin cizimi yapiliyor. update() icerisinde
// ise kapan nesnesinin cesitli durumlari arasinda gecis saglaniyor.

class Trap {

public:

   enum eTrapState { TS_DEPLOYING, TS_ACTIVE, TS_PASSIVE };
   
   Trap(float life_timet);
   ~Trap();

   void     setPos(const Vector3d &p)   { pos = p; };
   Vector3d getPos()   { return pos; };
   eTrapState getState()   { return state; };
   
   void init();
   void update(float dt);
   void render();

protected:

   eTrapState state;
   Vector3d pos;
   
   Particle *pengine;

   static bool first_init;
   static Model *model;
   static Model *model2;
   float  time;
   float  life_time;
   

};

#endif