////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#include "UI.h"


//----------------- class UIWidget ----------------- 

const char* UIWidget :: print() {  
   const char *widget_types[] = {"WT_LABEL","WT_BANNER","WT_MENU","WT_GMENU","WT_EDIT","WT_PANEL"}; 
   static char infostr[256];
   sprintf(infostr,"widget_id:%d widget_type:%s",id,widget_types[wtype]);
   return infostr;
}

//----------------- class UILabel ----------------- 

UILabel :: UILabel(const char *txt,float nx,float ny) {
   setText(txt);  
   setColor(1,1,1);
   setPos(nx,ny);

   wtype = WT_LABEL;
}

void UILabel :: setText(const char *txt) {
   strcpy(text,txt);
}

void UILabel :: setText(float val) {
   char txt[256];
   sprintf(txt,"%.1f",val);
   strcpy(text,txt);
}

UIEvent UILabel :: onKeyEvent(const SDLKey &key) {
   if (key == SDLK_RETURN)
      return UIEvent(UIEvent::UIEVT_UILABEL_ENTERPRESSED,this,0);
   else
      return UIEvent(UIEvent::UIEVT_UILABEL_UPDOWNKEYPRESSED,this,0);
}

void UILabel :: render() {

   glEnable(GL_BLEND);
   glBlendFunc(GL_ONE,GL_ONE);
   
   glColor3f(colr,colg,colb);
   glPushMatrix();
   glScalef(0.01f,0.01f,0.01f);
   glFontTextOut(text);
   glPopMatrix();
}

//----------------- class UIBanner ----------------- 

UIBanner :: UIBanner(const char *texturename,float x,float y,float szx,float szy) {
   setPos(x,y);
   this->szx = szx;
   this->szy = szy;

   tex = new Texture(texturename);
   //tex->enableMipmapping(false);
   tex->build();

   wtype = WT_BANNER;
}

UIEvent UIBanner :: onKeyEvent(const SDLKey &key) {
   if (key == SDLK_RETURN)
      return UIEvent(UIEvent::UIEVT_UIBANNER_ENTERPRESSED,this,0);
   else
      return UIEvent(UIEvent::UIEVT_UIBANNER_UPDOWNKEYPRESSED,this,0);
}

void UIBanner :: render() {
   
   glEnable(GL_BLEND);
   glBlendFunc(GL_SRC_ALPHA,GL_ONE);
   
   glColor3f(1,1,1);
   
   glMatrixMode(GL_TEXTURE);
   glPushMatrix();
   
   tex->begin();
   glBegin(GL_QUADS);
      glTexCoord2f(0,0); glVertex2f(0,-szy);
      glTexCoord2f(1,0); glVertex2f(szx,-szy);
      glTexCoord2f(1,1); glVertex2f(szx,0);
      glTexCoord2f(0,1); glVertex2f(0,0);
   glEnd();
   tex->end();

   glMatrixMode(GL_TEXTURE);
   glPopMatrix();
   glMatrixMode(GL_MODELVIEW);
   

}

//----------------- class UIEdit ----------------- 

UIEvent UIEdit :: onKeyEvent(const SDLKey &key) {  
   
   if (key == SDLK_BACKSPACE) {
      if (strlen(text) > 0)
         text[strlen(text)-1] = '\0';
   }
   else
   if (key == SDLK_RETURN) {
      epressed = true;
   }
   
   if (strlen(text) != max_chars) {

      if ((key >= SDLK_0 && key <= SDLK_z) || key == SDLK_SPACE) {
         char msg[256];
         sprintf(msg,"%s%c",text,(char)key);
         setText(msg);
      }

   }
   else {
      return UIEvent(UIEvent::UIEVT_UIEDIT_EDITISFULL,this,0);
   }

   if (epressed)
      return UIEvent(UIEvent::UIEVT_UIEDIT_ENTERPRESSED,this,0);

   return UIEvent(UIEvent::UIEVT_UIEDIT_ORDINARYKEYPRESSED,this,0);
}

void UIEdit :: render() {
   UILabel::render();
}

//----------------- class UIPanel ----------------- 

UIEvent UIPanel :: onKeyEvent(const SDLKey &key) {
   
   if (focusedWidget)
      return focusedWidget->onKeyEvent(key);
   else   
      return UIEvent(UIEvent::UIEVT_UNKNOWN,this,0);

}

void UIPanel :: update(float dt) {
   
   UIWidget::update(dt);
   
   WidgetList::iterator it = widgets.begin();
   while (it != widgets.end()) {
      if ((*it)->isVisible())
         (*it)->update(dt);
      ++it;
   }
}

void UIPanel :: render() {
   WidgetList::iterator it = widgets.begin();
   while (it != widgets.end()) {

      UIWidget *w = *it;

      if (w->isVisible()) {
         float nx,ny;
         w->getPos(&nx,&ny);

         glPushMatrix();
         glTranslatef(nx,ny,0);
         
         w->render();
         glPopMatrix();
      }
      
      ++it;
   }
}

UIWidget* UIPanel :: addWidget(UIWidget *w) {
   widgets.push_back(w);
   if (focusedWidget)
      focusedWidget->setFocus(false);
   focusedWidget = w;
   w->setFocus(true);
   return w;
};

void UIPanel :: setFocus(bool f) {
   
   UIWidget::setFocus(f);
   
   WidgetList::iterator it = widgets.begin();
   while (it != widgets.end()) {
      (*it)->setFocus(true);
      ++it;
   }
}

//----------------- class UIMenu ----------------- 

void UIMenu :: addItem(const char *txt,float nx,float ny) {
   UILabel *l = new UILabel(txt,nx,ny);
   labels.push_back(l);
}

void UIMenu :: update(float dt) {
   
   UIWidget::update(dt);
   
   for (int i=0;i<labels.size();++i) {
      labels[i]->update(dt);
   }
}

UIEvent UIMenu :: onKeyEvent(const SDLKey &key) {
   switch (key) {
      case SDLK_UP:
         selectItem(currSelectedItem-1);
         labels[currSelectedItem]->onKeyEvent(key);
         break;
      case SDLK_DOWN:
         selectItem(currSelectedItem+1);
         labels[currSelectedItem]->onKeyEvent(key);
         break;
      case SDLK_RETURN:
         labels[currSelectedItem]->onKeyEvent(key);
         break;
   }
   return UIEvent(UIEvent::UIEVT_UNKNOWN,this,0);
}

void UIMenu :: render() {
   for (int i=0;i<labels.size();++i) {
      
      float lx,ly;
      labels[i]->getPos(&lx,&ly);
      
      glPushMatrix();
      glTranslatef(lx,ly,0);
      glScalef(0.01f,0.01f,0.01f);
      
      if (i == currSelectedItem)
         glScalef(2,1,1);

      labels[i]->render();
      glPopMatrix();
   }
}

//----------------- class UIGfxMenu ----------------- 

void UIGfxMenu :: addItem(UIBanner *unselected, UIBanner *selected) {
   selectedBanners.push_back(selected);
   unselectedBanners.push_back(unselected);
}

UIEvent UIGfxMenu :: onKeyEvent(const SDLKey &key) {
   
   UIEvent evt(UIEvent::UIEVT_UNKNOWN,this,0);
   
   switch (key) {
      case SDLK_UP:
         selectItem(currSelectedItem-1);
         evt.type = UIEvent::UIEVT_UIGFXMENU_ONITEM;
         //selectedBanners[currSelectedItem]->onKeyEvent(key);
         evt.data = currSelectedItem;
         break;
      case SDLK_DOWN:
         selectItem(currSelectedItem+1);
         evt.type = UIEvent::UIEVT_UIGFXMENU_ONITEM;
         //evt = selectedBanners[currSelectedItem]->onKeyEvent(key);
         evt.data = currSelectedItem;
         break;
      case SDLK_RETURN:
         evt.type = UIEvent::UIEVT_UIGFXMENU_ITEMSELECTED;
         evt.data = currSelectedItem;
         //evt = selectedBanners[currSelectedItem]->onKeyEvent(key);
         break;
   } 
   
   return evt;
}

void UIGfxMenu :: update(float dt) {
   
   UIWidget::update(dt);
   
   for (int i=0;i<selectedBanners.size();++i) {
      selectedBanners[i]->update(dt);
      unselectedBanners[i]->update(dt);
   }
}

void UIGfxMenu :: render() {
   
   glEnable(GL_BLEND);
   glBlendFunc(GL_SRC_ALPHA,GL_ONE);
      
   for (int i=0;i<selectedBanners.size();++i) {
      
      float lx,ly;
      selectedBanners[i]->getPos(&lx,&ly);
      
      glPushMatrix();
      glTranslatef(lx,ly,0);
      
      if (i == currSelectedItem)
         selectedBanners[i]->render();
      else
         unselectedBanners[i]->render();
      
      glPopMatrix();
   }

   if (selectorBanner != NULL) {      

      float nx,ny,offx,offy;
      selectedBanners[currSelectedItem]->getPos(&nx,&ny);
      selectorBanner->getPos(&offx,&offy);

      glPushMatrix();
      glTranslatef(nx+offx,ny+offy,0);
      selectorBanner->render();
      glPopMatrix();

   }
}

//----------------- class UIManager ----------------- 

UIManager :: UIManager(UIOwner *owner) {
   freeid_counter = 0;
   focusedWidget = NULL;
   visible = true;
   this->owner = owner;
}

UIManager :: ~UIManager() {
   glFontDestroy(&glf);
}

void UIManager :: init() {
   
   unsigned int texid;
   glGenTextures(1,&texid);
   
   glFontCreate(&glf,"data/font.glf",texid);
}

void UIManager :: update(float dt) {
   WidgetList::iterator i = widgets.begin();
   while (i != widgets.end()) {
      (*i)->update(dt);
      ++i;
   }
}

void UIManager :: keyEvent(const SDLKey &key) {
   
   if (visible && focusedWidget) {
      UIEvent evt = focusedWidget->onKeyEvent(key);
      if (owner)
         owner->UIEvent_Callback(&evt);
   }
   
}

void UIManager :: render() {
   
   if (!visible)
      return;
   
   glMatrixMode(GL_PROJECTION);
   glPushMatrix();
   glLoadIdentity();
   glOrtho(0,1,0,1,-1,1);

   glMatrixMode(GL_MODELVIEW);
   glPushMatrix();
   glLoadIdentity();
      
   glPushAttrib(GL_COLOR_BUFFER_BIT | GL_CURRENT_BIT | GL_ENABLE_BIT);
   glEnable(GL_TEXTURE_2D);
   glDisable(GL_LIGHTING);
   glDisable(GL_FOG);
   glDisable(GL_DEPTH_TEST);

   glMatrixMode(GL_TEXTURE);
   glPushMatrix();
   glLoadIdentity();
   glMatrixMode(GL_MODELVIEW);
   
   glFontBegin(&glf);
   
   WidgetList::iterator i = widgets.begin();
   while (i != widgets.end()) {
      
      UIWidget *w = *i;
      if (w->isVisible()) {
         float nx,ny;
         w->getPos(&nx,&ny);

         glPushMatrix();
         glTranslatef(nx,ny,0);
         
         w->render();
         glPopMatrix();
      }

      ++i;
   }

   glFontEnd();

   
   glMatrixMode(GL_TEXTURE);
   glPopMatrix();

   glPopAttrib();

   glMatrixMode(GL_MODELVIEW);
   glPopMatrix();
   
   glMatrixMode(GL_PROJECTION);
   glPopMatrix();

   glMatrixMode(GL_MODELVIEW);

}

void UIManager :: focusWidget(UIWidget *w) {
   if (focusedWidget)
      focusedWidget->setFocus(false);
   
   focusedWidget = w;
   if (w)
      w->setFocus(true);
}

void UIManager :: addWidget(UIWidget *w) {
   if (w->getID() == -1)
      w->setID(freeid_counter++);
   widgets.push_back(w);

   if (focusedWidget == NULL) {
      focusWidget(w);
   }
}

UILabel* UIManager :: addLabel(const char *text,float x,float y) {

   UILabel *l = new UILabel(text,x,y);
   addWidget(l);

   return l;
}

/*
UIMenu* UIManager :: addMenu() {

   UIMenu *menu = new UIMenu;
   menu->setPos(0,0);
   
   addWidget(menu);
   ++menuCount;

   return menu;
};
*/

UIGfxMenu* UIManager :: addGfxMenu() {

   UIGfxMenu *menu = new UIGfxMenu;
   menu->setID(freeid_counter++);
   menu->setPos(0,0);
   
   addWidget(menu);

   return menu;
}

UIEdit* UIManager :: addEdit() {

   UIEdit *edit = new UIEdit;
   edit->setPos(0,0);

   addWidget(edit);

   return edit;
}

UIPanel* UIManager :: addPanel() {

   UIPanel *p = new UIPanel;
   p->setPos(0,0);
   
   addWidget(p);

   return p;
}



