#ifndef __Q3BspRenderer_h__
#define __Q3BspRenderer_h__

#include <lib3d/bsp/q3bsp_types.h>
#include <lib3d/util3d/Vector3d.h>
#include <lib3d/util2d/Texture.h>
#include <lib3d/util3d/Frustum.h>
#include <lib3d/util3d/collision/vectormath.h>

#define Q3BSP_EPSILON 0.001f;

enum Q3BSP_ERRCODES { Q3BSP_NOERROR = 0, Q3BSP_ERR_FILE_NOT_FOUND,
                       Q3BSP_ERR_BADID, Q3BSP_ERR_NOT_SUPPORTED_VERSION,
                        Q3BSP_ERR_MISSING_TEXTURE };

#define SHADER_TEXTURE "___shader.jpg"

class Q3BspRenderer {

public:
   Q3BspRenderer();
   virtual ~Q3BspRenderer();

   void setScale(float scale) { levelScale = scale; }
   void setTexturePath(const char *path);
   int  getCurrentCluster()   { return currCluster; }
   int  getRenderedFaceCount() { return faceRendered; }
   void enablePVS(bool enable) { pvsEnabled = enable; }
   
   int  load(const char *bspfile);
   bool checkCollision(const Vector3d *pos,Vector3d *pos_out);
   void render(const Vector3d *eyePos);

protected:
 
   bool searchAndLoadTexture(int idx,q3bsp_tBSPTexture *tex);
   q3bsp_tBSPLeaf*  findLeaf(const Vector3d *eyePos);
   void renderClusterBounds();
   
   q3bsp_tBSPVertex  *vertices;
   q3bsp_tBSPFace    *faces;
   q3bsp_tBSPPlane   *planes;
   q3bsp_tBSPNode    *nodes;
   q3bsp_tBSPLeaf    *leafs;
   q3bsp_tBSPBrush   *brushes;
   q3bsp_tBSPBrushSide *brushSides;
   q3bsp_tBSPVisData  visdata;
   int *leafFaces;
   int *leafBrushes;

   int vertexCount;
   int faceCount;
   int planeCount;
   int nodeCount;
   int leafCount;
   int visdataCount;
   int leafFaceCount;
   int brushCount;
   int brushSideCount;
   int leafBrushCount;

   float levelScale;
   int   currCluster;
   bool  pvsEnabled;
   int   faceRendered;

   Texture *textures[MAX_TEXTURE_COUNT];
   Texture *lightmaps[MAX_TEXTURE_COUNT];
   Frustum frustum;
   CBitset faceDrawStatus;
   char texpath[256];

};


#endif