#pragma warning (disable : 4786)

#ifndef __OBJLOADER_H__
#define __OBJLOADER_H__

#include <stdio.h>
#include <lib3d/model/model.h>

class ObjLoader {

private:
   ObjLoader();

   enum TokenType { TT_notvalid, TT_v, TT_vn, TT_vt, TT_f, TT_o, TT_s, TT_usemtl, TT_mtllib };
public:
   ~ObjLoader();

   Model* load(char *path);
   static ObjLoader* instance();

protected:

   void readVertexData(const char *line,tVertex *dest);
   void readNormalData(const char *line,Vector3d *dest);
   void readTextureData(const char *line,tUV *dest);
   void readFaceData(const char *line,tFace *dest);
   void skipLine();
   void readLine(char *line);
   TokenType getTokenType(const char *line);

   FILE *fp;
};


#endif