#ifndef _LOAD3DS_H
#define _LOAD3DS_H

#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>

// chunk larn numaralar yerine isimlerini kullanalm
#define VERTEX_LIST	0x4110	
#define FACE_LIST	0x4120 	
#define UV_LIST		0x4140	
#define MAIN3DS		0x4d4d	
#define EDITOR_CH	0x3d3d	
#define NAME_CH		0x4000
#define TRIMESH		0x4100

/* 
/  Maximum deerler, aslnda dosyadan ilgili yerin uzunluunu okuduktan 
/  sonra dinamik olarak yer ayrabiliriz, ancak yaptm denemeler, 
/  dk poligonlu modellerde, bu yntemin daha iyi olduunu gsterdi, 
/  yine de karar sizin. Oyunda ok farkl byklklerde modeller olabilecei 
/  iin motor yazarken dinamik daha avantajl.
*/
#define MAX_VERTEX 2000	
#define MAX_POLYGON 2000

// float 3d vector snf
class CVector3f{
public:
	float x,y,z;
};
// poligon snf, geni oluturan vectorlerin numaralarn tutar
class CPolygon{
public:
	int a,b,c;
};
// kaplama koordinat snf
class CTexCoor{
public:
	float u,v;
};

//3ds dosya format yukleme snf
class CLoad3ds 
{
private:
	CVector3f	Vertices[MAX_VERTEX];
    CPolygon	Polygons[MAX_POLYGON];
    CTexCoor	TexCoords[MAX_VERTEX];

	int polyCount;		//poligon says
	int vertCount;		//vertex says
	int texcoorCount;	//kaplama koordinat says

	char name[20];

public:
	CLoad3ds() { };		//yapc
	~CLoad3ds() { };	//ykc

	int Texture_ID;		//kaplama numaras

	bool Load(char *filename);
	void Draw();
};

#endif	//_LOAD3DS_H
