
#include "load3ds.h"
#include <stdio.h>
#include <io.h>	 //dosya uzunluunu bulmak iin


// Bu ksmda modeli yukluyoruz. 3ds format binary olduu iin yklenmesi iin 
// n bilgi gerekir. Burada yaplanlar tamamen model format
// ile alakal olduu iin pek neden-nasl aklamaya gerek yok. Dosya 
// formatn ok beenenler eitli sitelerden spec indirip tm zelliklerine,
// hangi yerin ne boyutta olduuna, ne ie yaradna bakabilir. (wotsit.org a bakabilirsiniz)
// Ben sadece modeli izmek iin gerekli ksmlar yukluyorum:
// vertexler, uv ler, poligon indisleri. 
bool CLoad3ds::Load(char *filename)
{
	int i;	
	FILE *file; //aacamz dosya

	// ykleme srasnda lazm olan deikenler
	unsigned short chunk;		// chunk belirleyici, hangi veriyi okuyacamz gsterecek
	unsigned int u_chunk;		// incelenen chunk n uzunluu

	unsigned char str;			// dosyadan karakterler okurken tekrarl olarak kullanacamz tek karakter
	unsigned short ele_n;		// chunk iindeki element says, r: vertex iin olan chunk da ka vertex bulunduu

	unsigned short face_i;	/* 
								yzeye ait zel bilgiler, biz burada sadece okuyacaz,
								kullanm farkl ekillerde olabilir.
								eer okumazsak offset kayaca iin
								model bozuk grntlenecektir(yanl yerlere poligon izilir)
							*/

	if ((file=fopen (filename, "rb"))== NULL) 
	{
		char str[50];
		sprintf(str, "%s model dosyas yklenemedi", filename);
		MessageBox(NULL, str, "!!HATA!!", 0);
		return 0; // Hata olutuunu bildir
	}

	printf("Yukleniyor : %s", filename);	/*console ierisine yukleniyor yazarak 
											modelin yklenmekte olduunu belirtelim */
	
	//Tm dosyay taratyoruz
	while (ftell (file) < filelength (fileno (file))) 
	{
		fread (&chunk, 2, 1, file);	
		fread (&u_chunk, 4, 1, file);	

		switch (chunk)
        {
			case MAIN3DS: //ana chunk, modeli tutar
				break;    

			case NAME_CH:  
				i=0;
				// ismi oku
				do
				{
					fread (&str, 1, 1, file);
                    name[i]=str;
					i++;
                }while(str != '\0' && i<20);
				break;

			// vertex konumlar
			case VERTEX_LIST: 
				// eleman saysn oku
				fread (&ele_n, sizeof(short), 1, file);
                vertCount = ele_n;	// modelin vertex says
				// elemanlar oku
                for (i=0; i<ele_n; i++)
                {
					fread (&Vertices[i].x, sizeof(float), 1, file);
                    fread (&Vertices[i].y, sizeof(float), 1, file);
					fread (&Vertices[i].z, sizeof(float), 1, file);
				}
				break;
			//kaplama koordinatlar listesi
			case UV_LIST:
				// eleman saysn oku
				fread (&ele_n, sizeof
					(short), 1, file);
				texcoorCount = ele_n;
				// elemanlar oku
				for (i=0; i<ele_n; i++)
				{
					fread (&TexCoords[i].u, sizeof(float), 1, file);//u
                    fread (&TexCoords[i].v, sizeof(float), 1, file);//v
				}
                break;
			//poligon listesi
			case FACE_LIST:
				// eleman saysn oku
				fread (&ele_n, sizeof (unsigned short), 1, file);
                polyCount = ele_n;	// modelin poligon saysn soran olursa
				// elemanlar oku
                for (i=0; i<ele_n; i++)
                {
					fread (&Polygons[i].a, sizeof(short), 1, file);
					fread (&Polygons[i].b, sizeof(short), 1, file);
					fread (&Polygons[i].c, sizeof(short), 1, file);
					fread (&face_i, sizeof(short), 1, file);
				}
                break;

			case TRIMESH:	// ilem yapmyoruz
				break;
			case EDITOR_CH:	// ilem yapmyoruz 
				break;

			//dier bilgileri atlyoruz
			default:
				 fseek(file, u_chunk-6, SEEK_CUR);
        } 
	}
	fclose(file);	// Dosyay kapatyoruz

	return(1);		// Dosya sorunsuz yklendi
}


void CLoad3ds::Draw()
{
	//kaplamamz se(kaplama yuklemesi iin id dndren fonksiyon main.cpp de: LoadBMP)
	glBindTexture(GL_TEXTURE_2D, Texture_ID);

	glBegin(GL_TRIANGLES); // genler halinde modeli iziyoruz
	for (int i=0; i<polyCount; i++) 
	{
		// ilk vertex e ait kaplama koordinatlar
		glTexCoord2f( TexCoords[Polygons[i].a ].u,
					  TexCoords[Polygons[i].a ].v);
		// Vertex Koordinatlar
		glVertex3f( Vertices[Polygons[i].a ].x,
					Vertices[Polygons[i].a ].y,
					Vertices[Polygons[i].a ].z); //Vertex definition

		// ikinci vertex e ait kaplama koordinatlar
		glTexCoord2f( TexCoords[Polygons[i].b ].u,
					  TexCoords[Polygons[i].b ].v);	
		// Vertex Koordinatlar					
		glVertex3f( Vertices[Polygons[i].b ].x,
					Vertices[Polygons[i].b ].y,	
					Vertices[Polygons[i].b ].z);

		// son vertex e ait kaplama koordinatlar
		glTexCoord2f( TexCoords[Polygons[i].c ].u,
					  TexCoords[Polygons[i].c ].v);
		// Vertex Koordinatlar
		glVertex3f( Vertices[Polygons[i].c ].x,
					Vertices[Polygons[i].c ].y,
					Vertices[Polygons[i].c ].z);
	}
	glEnd();
}

