/*                                    _     _
                                     (o\---/o)
                                      ( , , )
_____STROMA_______________________,~~.(_(T)_),~~.____________________________
|/                                "--"       "--"                           \|
|   Merhaba, bu derste yaygn olarak kullanlan 3ds formatn inceleyeceiz. |
|                                                                            |
|   3DS Model format pek ok model editoru tarafndan desteklenmektedir.    |
|  Bu nedenle pek ok motor modelistleri dnerek bu format destekleyici   |
|  snflar bulundurur. 3ds formatnn zelii bilgileri chunk yaplar      |
|  ierisinde tutmasdr. Bu yaplarn numaralar vardr.Dosya alr case   |
|  komutu ile uygun chunk iin uygun ilem yaplr. Bu derste tm chunk lar |
|  incelemeyeceim. Sadece modeli grntlemek iin lazm olan vertex, uv    |
|  ve poligon listeleri ile alacaz. steyenler material zellikleri,    |
|  yzey bilgileri gibi birimleri de kullanabilirler. daha fazla lafa gerek  |
|  yok sanrm, kodlar yeterince anlalr ve ayrca bir yaz yazmaya gerek  |
|  duymadm. Ders hakknda tm grlerinizi, eksik veya yanl olduunu     |
|  dndnz ksmlar ltfen bana iletiniz.                              |
|    Serdar - stroma@spymac.com	                                             |
|             www.mikrop.gen.tr                                              |
|  *Modeli ve kodlar, dilediiniz gibi kullanabilirsiz.                     |
|  **Balang seviyesinde OpenGL bilgisi gerektirir.                        |
|                                  _,-.     ,-._                             |
|\________________________________(ooO )___( Ooo)___________________________/|
                                  ((_) )   ( (_))
                                \* "--"     "--" */
#include <windows.h>
#include <GL/glut.h>

#pragma comment(lib, "opengl32.lib")
#pragma comment(lib, "glu32.lib")
#pragma comment(lib, "glut32.lib")

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>

#include "load3ds.h"

int LoadBMP(char *filename);	// klasik bir bmp yukleme kodu
void GetFPS();					// Fps hesaplatma kodu

///////////////////
//Degiskenler
int genislik	=640;	//ekran boyutlar
int yukseklik	=480;

float time;	// zamana bal hareket iin

//Silah isimli bir 3ds modeli tanmlyoruz
CLoad3ds Model;

///////////////////
//opengl init kodu, klasik ilemler yansra silah ve kaplamasn buradan yukletiyoruz
void init(void)
{
    glClearColor(0.2, 0.25, 0.8, 0.0);	
    glViewport(0,0,genislik,yukseklik);  

    glMatrixMode(GL_PROJECTION);	
    glLoadIdentity(); 
    gluPerspective(45.0f,(GLfloat)genislik/(GLfloat)yukseklik,10.0f,10000.0f); 
   
    glEnable(GL_DEPTH_TEST);
    glPolygonMode (GL_FRONT_AND_BACK, GL_FILL); 

    glEnable(GL_TEXTURE_2D);					// Kaplama iin

    Model.Load("starz70.3ds");					// Modeli yukle
    Model.Texture_ID = LoadBMP("kaplama.bmp");	// Kaplamasn yukle
}


// Ekran boyutlandrldnda arlacak klasik fonksiyon
void resize(int w, int h)	//w, h  deerlerine boyutlandrlma
{
    genislik	= w; 
    yukseklik	= h; 

    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); 
    glViewport(0,0,genislik,yukseklik);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity(); 
    gluPerspective(45.0f,(GLfloat)genislik/(GLfloat)yukseklik,10.0f,10000.0f);

    glutPostRedisplay ();
}


// Render fonksiyonumuz
void render(void)
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); // This clear the background color to dark blue
    glMatrixMode(GL_MODELVIEW); // Modeling transformation
    glLoadIdentity(); // Initialize the model matrix as identity
    
    glTranslatef(0,0,-400);

	static float ang;
	ang += 50 * time;
    glRotatef(ang, 0,1,0);

	Model.Draw();

	GetFPS();

    glutSwapBuffers();
}

//ana yordam
int main(int argc, char **argv)
{
    glutInit(&argc, argv);    
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
    glutInitWindowSize(genislik,yukseklik);
    glutInitWindowPosition(0,0);
    glutCreateWindow("3ds Yukleme");    
    glutDisplayFunc(render);
    glutIdleFunc(render);
    glutReshapeFunc (resize);
    init();
    glutMainLoop();

    return(0);    
}

//klasik bir bmp yukleme kodu
int LoadBMP(char *filename) 
{
	int j = 0;
    FILE *file; 
    unsigned char *texture; 
     
    BITMAPFILEHEADER fileheader; 
    BITMAPINFOHEADER infoheader;
    RGBTRIPLE rgb;

	static int id;	
    id++;

    if( (file = fopen(filename, "rb"))==NULL) 
		return (-1);	
    
    fread(&fileheader, sizeof(fileheader), 1, file);
    
    fseek(file, sizeof(fileheader), SEEK_SET);
    fread(&infoheader, sizeof(infoheader), 1, file); 

    texture = (BYTE *) malloc(infoheader.biWidth * infoheader.biHeight * 4);
    memset(texture, 0, infoheader.biWidth * infoheader.biHeight * 4);
 
    for (int i = 0; i < infoheader.biWidth*infoheader.biHeight; i++)
    {            
            fread(&rgb, sizeof(rgb), 1, file); 

            texture[j+0] = rgb.rgbtRed;
            texture[j+1] = rgb.rgbtGreen;
            texture[j+2] = rgb.rgbtBlue;
            texture[j+3] = 255;			
            j += 4;							
    }

    fclose(file); 
    
	glBindTexture(GL_TEXTURE_2D, id);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR); 
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST); 

    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

    glTexImage2D(GL_TEXTURE_2D, 0, 4, infoheader.biWidth, infoheader.biHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, texture);
    gluBuild2DMipmaps(GL_TEXTURE_2D, 4, infoheader.biWidth, infoheader.biHeight, GL_RGBA, GL_UNSIGNED_BYTE, texture);

    free(texture); 

    return (id);
}

//ekrana saniyede ka kare oynatldn yazar
void GetFPS()
{
	//fps deikenimiz
   static float FPS = 0.0f;

	//sonraki saniye
   float next = 0.0f;

	//nceki saniye
   static float prev = 0.0f;

   FPS++;	//frame saysn her render fonksiyonunda 1 artryoruz

   next = GetTickCount() * 0.001f;	//milisaniyeyi saniyeye evir	
  
   	static float frameTime = 0.0f;
    float current = GetTickCount() * 0.001f;

 	time = current - frameTime;
	frameTime = current;

	//eer 1 saniye gemise ekrana o zamana kadar gecen frame saysn artryoruz
   if(current - prev > 1.0f)
   {
      prev = next;
	  if(FPS != 1)						//ilk gelecek olan frame says 1 olacaktr
		printf("\n FPS : %d", int(FPS));//bu pek iyi gzkmeyen bir durum olduu iin yazdrmadk

      FPS = 0;	// fps yi sfrlyoruz ki sonraki kullanmlarda fps artp durmasn
   }
}



/*
 Sanrm bunu da eklemeyerek dersi bitirebiliriz: 

     MAIN3DS  (0x4D4D)

                  |

                  +--EDIT3DS  (0x3D3D)

                  |  |

                  |  +--EDIT_MATERIAL (0xAFFF)

                  |  |  |

                  |  |  +--MAT_NAME01 (0xA000) (See mli Doc) 

                  |  |

                  |  +--EDIT_CONFIG1  (0x0100)

                  |  +--EDIT_CONFIG2  (0x3E3D) 

                  |  +--EDIT_VIEW_P1  (0x7012)

                  |  |  |

                  |  |  +--TOP            (0x0001)

                  |  |  +--BOTTOM         (0x0002)

                  |  |  +--LEFT           (0x0003)

                  |  |  +--RIGHT          (0x0004)

                  |  |  +--FRONT          (0x0005) 

                  |  |  +--BACK           (0x0006)

                  |  |  +--USER           (0x0007)

                  |  |  +--CAMERA         (0xFFFF)

                  |  |  +--LIGHT          (0x0009)

                  |  |  +--DISABLED       (0x0010)  

                  |  |  +--BOGUS          (0x0011)

                  |  |

                  |  +--EDIT_VIEW_P2  (0x7011)

                  |  |  |

                  |  |  +--TOP            (0x0001)

                  |  |  +--BOTTOM         (0x0002)

                  |  |  +--LEFT           (0x0003)

                  |  |  +--RIGHT          (0x0004)

                  |  |  +--FRONT          (0x0005) 

                  |  |  +--BACK           (0x0006)

                  |  |  +--USER           (0x0007)

                  |  |  +--CAMERA         (0xFFFF)

                  |  |  +--LIGHT          (0x0009)

                  |  |  +--DISABLED       (0x0010)  

                  |  |  +--BOGUS          (0x0011)

                  |  |

                  |  +--EDIT_VIEW_P3  (0x7020)

                  |  +--EDIT_VIEW1    (0x7001) 

                  |  +--EDIT_BACKGR   (0x1200) 

                  |  +--EDIT_AMBIENT  (0x2100)

                  |  +--EDIT_OBJECT   (0x4000)

                  |  |  |

                  |  |  +--OBJ_TRIMESH   (0x4100)      

                  |  |  |  |

                  |  |  |  +--TRI_VERTEXL          (0x4110) 

                  |  |  |  +--TRI_VERTEXOPTIONS    (0x4111)

                  |  |  |  +--TRI_MAPPINGCOORS     (0x4140) 

                  |  |  |  +--TRI_MAPPINGSTANDARD  (0x4170)

                  |  |  |  +--TRI_FACEL1           (0x4120)

                  |  |  |  |  |

                  |  |  |  |  +--TRI_SMOOTH            (0x4150)   

                  |  |  |  |  +--TRI_MATERIAL          (0x4130)

                  |  |  |  |

                  |  |  |  +--TRI_LOCAL            (0x4160)

                  |  |  |  +--TRI_VISIBLE          (0x4165)

                  |  |  |

                  |  |  +--OBJ_LIGHT    (0x4600)

                  |  |  |  |

                  |  |  |  +--LIT_OFF              (0x4620)

                  |  |  |  +--LIT_SPOT             (0x4610) 

                  |  |  |  +--LIT_UNKNWN01         (0x465A) 

                  |  |  | 

                  |  |  +--OBJ_CAMERA   (0x4700)

                  |  |  |  |

                  |  |  |  +--CAM_UNKNWN01         (0x4710)

                  |  |  |  +--CAM_UNKNWN02         (0x4720)  

                  |  |  |

                  |  |  +--OBJ_UNKNWN01 (0x4710)

                  |  |  +--OBJ_UNKNWN02 (0x4720)

                  |  |

                  |  +--EDIT_UNKNW01  (0x1100)

                  |  +--EDIT_UNKNW02  (0x1201) 

                  |  +--EDIT_UNKNW03  (0x1300)

                  |  +--EDIT_UNKNW04  (0x1400)

                  |  +--EDIT_UNKNW05  (0x1420)

                  |  +--EDIT_UNKNW06  (0x1450)

                  |  +--EDIT_UNKNW07  (0x1500)

                  |  +--EDIT_UNKNW08  (0x2200)

                  |  +--EDIT_UNKNW09  (0x2201)

                  |  +--EDIT_UNKNW10  (0x2210)

                  |  +--EDIT_UNKNW11  (0x2300)

                  |  +--EDIT_UNKNW12  (0x2302)

                  |  +--EDIT_UNKNW13  (0x2000)

                  |  +--EDIT_UNKNW14  (0xAFFF)

                  |

                  +--KEYF3DS (0xB000)

                     |

                     +--KEYF_UNKNWN01 (0xB00A)

                     +--............. (0x7001) ( viewport, same as editor )

                     +--KEYF_FRAMES   (0xB008)

                     +--KEYF_UNKNWN02 (0xB009)

                     +--KEYF_OBJDES   (0xB002)

                        |

                        +--KEYF_OBJHIERARCH  (0xB010)

                        +--KEYF_OBJDUMMYNAME (0xB011)

                        +--KEYF_OBJUNKNWN01  (0xB013)

                        +--KEYF_OBJUNKNWN02  (0xB014)

                        +--KEYF_OBJUNKNWN03  (0xB015)  

                        +--KEYF_OBJPIVOT     (0xB020)  

                        +--KEYF_OBJUNKNWN04  (0xB021)  

                        +--KEYF_OBJUNKNWN05  (0xB022)  


  Buradakilerin hepsini kullanabilirsiniz.
  Tabii modeli export eden birimin de sizin ilem yapacanz blmleri 
  dikkate almas gerekiyor. Aksi halde kodunuzda hata arar durursunuz. :)

  Internette 3ds formatn ykleme hakknda pek ok yaz bulunmakta, arama
  motorlar ile bunlar rahatlkla bulabilirsiniz. 

  Grmek zere...
  +-+-+-+-+-+-+-+-
  STR
*/


