//========================================================================
//    NeHe OpenGL Wizard : NeHeSimple.cpp
//    Wizard Created by: Vic Hollis
//========================================================================
/*
 *		This Code Was Created By Jeff Molofee 2000
 *		A HUGE Thanks To Fredric Echols For Cleaning Up
 *		And Optimizing This Code, Making It More Flexible!
 *		If You've Found This Code Useful, Please Let Me Know.
 *		Visit My Site At nehe.gamedev.net
 *
 *		BU PROJENN YAPIMINDA NEHE GL BASECODE <<SIMPLE>> KULLANILMITIR
 */

#include <windows.h>		// Header File For Windows
#include <gl\gl.h>			// Header File For The OpenGL32 Library
#include <gl\glu.h>			// Header File For The GLu32 Library
#include <gl\glaux.h>		// Header File For The Glaux Library
#include <stdio.h>
#include <olectl.h>			// Header File For The OLE Controls Library	(Used In BuildTexture)
#include <math.h>			// Header File For The Math Library			(Used In BuildTexture)

#pragma comment( lib, "opengl32.lib" )	// Search For OpenGL32.lib While Linking
#pragma comment( lib, "glu32.lib" )		// Search For GLu32.lib While Linking
#pragma comment( lib, "glaux.lib" )		// Search For GLaux.lib While Linking

HDC			hDC=NULL;		// Private GDI Device Context
HGLRC		hRC=NULL;		// Permanent Rendering Context
HWND		hWnd=NULL;		// Holds Our Window Handle
HINSTANCE	hInstance;		// Holds The Instance Of The Application

bool	keys[256];			// Array Used For The Keyboard Routine
bool	active=TRUE;		// Window Active Flag Set To TRUE By Default
bool	fullscreen=TRUE;	// Fullscreen Flag Set To Fullscreen Mode By Default
FILE	*fp;				// Dosya ykletip okutmamz iin
char	kod[255];			// Dosyadaki satrlar ilemek iin karakter dizimiz
int		kaplamali;
GLuint	texture[1];			// kaplamalar tutmak iin kullanacamz arrayimiz

LRESULT	CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);	// Declaration For WndProc
int BuildTexture(char *szPathName,GLuint &texid);

// Model iin Vertex bilgisini tutacak olan struct
struct Vertex
{
	float x,y,z; // x,y,z konumlarn tutacak deikenler
	float kU,kV; // kaplamalar iin UV koordinatlarn tutacak deikenler
};

// Modelimiz ekrana genler halinde izilecek bunun iin de gerekli vertex verisini
// barndracak olan yap
struct Ucgen
{
	Vertex vertex[3];// gen iin  x,y,z deeri kullanacamz belirtiyoruz
};

struct Model
{
	Ucgen	*ucgen;
	int		ucgenVerisi; // Modelde ka adet gen olduunu tutacak olan deiken
};

// Basit bir <<aklama ve bo satr atlama>> arac ayn zamanda her satr tarayarak
// her satr tek tek ilenmesi iin kod isimli karakter dizisine atar
void SatirAtla(FILE *dosya, char *karakterDizisi)
{
	do
	{
		fgets(karakterDizisi,255,dosya);
	}while((karakterDizisi[0] == '#') || (karakterDizisi[0] == '\n'));
	// Grdnz zere dediim gibi eer <<#>> iaretini ya da satr sonu ~ bo satr
	// grrse pas gemesini sylediimiz fonksiyon (devrik mi oldu acaba)
	// bu sayede gereksiz yere kod hafzamza bu satrlar iletmeyeceiz.
	// Basit ama kullanl eer aklamalarnz iin baka bir iaret kullanmak isterseniz
	// # iaretini deitirin
}

Model	model;

void ModelYukle(char *dosyaAdi)
{
	float x,y,z,u,v;
	int	ucgenVerisi;

	fp = fopen(dosyaAdi,"r"); // okumak iin dosyamz aalm

	SatirAtla(fp,kod);
	sscanf(kod,"UcgenSayisi >> %d\n", &ucgenVerisi); // UcgenSayisi >> say yazan yeri bulmasn
													 // ve bulunca bu deeri ucgenVerisine
													 // kaydetmesini sylyoruz

	SatirAtla(fp,kod); // Okumaya devam et [nk bir nceki sefer durdurmutu]
	sscanf(kod, "KaplamaKullanimi >> %d\n", &kaplamali); // ay ilemi kaplama iin kontrol et
														 // deiken 1'se kaplamal 0'sa normal

	model.ucgen = new Ucgen[ucgenVerisi];
	model.ucgenVerisi = ucgenVerisi;

	for(int dongu = 0; dongu < ucgenVerisi; dongu++)
	{
		for(int nokta = 0; nokta < 3; nokta++)
		{
			if(kaplamali == 1) // eer modelimiz kaplamalysa
			{
				SatirAtla(fp,kod); // dosyay okutmaya yeniden devam et
				sscanf(kod, "Vertex %f %f %f >> TKoord %f %f", &x, &y, &z, &u, &v);
				// Model dosyamz vertex ve kaplama koordinatlar iin ara ve sonular
				// x, y, z, u, v deikenlerine yaz

				model.ucgen[dongu].vertex[nokta].x = x; // dosya okunana kadar her genin
														//  vertexinden o anda ilenecek
														// olann x deerine okunan 
														// x deerlerinden
														// karlk geleni yaz
				model.ucgen[dongu].vertex[nokta].y = y;
				model.ucgen[dongu].vertex[nokta].z = z;
				// kaplamal olduu iin model dosyamzdan u v koordinatlarn da alyoruz
				model.ucgen[dongu].vertex[nokta].kU = u;
				model.ucgen[dongu].vertex[nokta].kV = v;
				// ite kaplamal modelimiz iin ortam hazrladk
			}
			else if(kaplamali == 0) // peki ya model kaplamasszsa
			{
				SatirAtla(fp,kod); // dosyay okutmaya yeniden devam et
				sscanf(kod, "Vertex %f %f %f", &x, &y, &z);
				// Model dosyamz vertex koordinatlar iin ara ve sonular
				// x, y, z deikenlerine yaz ama bu sefer kaplama koordinatlarn okuma

				model.ucgen[dongu].vertex[nokta].x = x; // dosya okunana kadar her genin
														//  vertexinden o anda ilenecek
														// olann x deerine okunan 
														// x deerlerinden
														// karlk geleni yaz
				model.ucgen[dongu].vertex[nokta].y = y;
				model.ucgen[dongu].vertex[nokta].z = z;
			}
		}
	}
	fclose (fp);
}
// Evet model dosyamz yklettik imdi sra izdirmede
// izim kodu nispeten daha basit
void ModelCiz()
{
	int ucgenVerisi = model.ucgenVerisi;
	for(int dongu = 0; dongu < ucgenVerisi; dongu++)
	{
		glPushMatrix(); // stack hadisesi iin
		if(kaplamali == 1)
		{
			glBegin(GL_TRIANGLES);
			glTexCoord2f(model.ucgen[dongu].vertex[0].kU, model.ucgen[dongu].vertex[0].kV);
			glVertex3f(  model.ucgen[dongu].vertex[0].x,  model.ucgen[dongu].vertex[0].y, model.ucgen[dongu].vertex[0].z);
			
			glTexCoord2f(model.ucgen[dongu].vertex[1].kU, model.ucgen[dongu].vertex[1].kV);
			glVertex3f(  model.ucgen[dongu].vertex[1].x,  model.ucgen[dongu].vertex[1].y, model.ucgen[dongu].vertex[1].z);
			
			glTexCoord2f(model.ucgen[dongu].vertex[2].kU, model.ucgen[dongu].vertex[2].kV);
			glVertex3f(  model.ucgen[dongu].vertex[2].x,  model.ucgen[dongu].vertex[2].y, model.ucgen[dongu].vertex[2].z);
			glEnd();
			glDisable(GL_TEXTURE_2D); // kaplama kodunu nceden ardmz var sayarak
			// evet eer kaplamalysa modelimizin kaplama koordinatlarn belirttik ve ardndan izdirdik
			// bunu bir dng iinde yaptndan model dosyasndaki her bir vertex
			// otomatik olarak izilecektir
		}
		else if(kaplamali == 0)
		{
			glBegin(GL_TRIANGLES);
			glVertex3f(model.ucgen[dongu].vertex[0].x, model.ucgen[dongu].vertex[0].y, model.ucgen[dongu].vertex[0].z);
			glVertex3f(model.ucgen[dongu].vertex[1].x, model.ucgen[dongu].vertex[1].y, model.ucgen[dongu].vertex[1].z);
			glVertex3f(model.ucgen[dongu].vertex[2].x, model.ucgen[dongu].vertex[2].y, model.ucgen[dongu].vertex[2].z);
			glEnd();
			// eer kaplamaszsa ayn ilemi kaplama koordinatlar kullanmadan uyguladk
		}
		glPopMatrix(); // stack olay iin; daha nceden push etmitik. 
					   // [alnt]her gl push'a bir gl pop koymalsn yani 1'e 1[/alnt]
					   // LOREN SOTH'A BANA STACK' TAM OLARAK RETT N TEEKKRLER
	}
}

// ve ite izim ilemi de bitti ve sra en basit ilem olan kaplama kodunda bunun iin
// ipicture kullanacam. eer bir motor yazyorsanz mutlaka eklemeyi unutmayn cidden kullanl
// ama ne yazkki tga ve png destei yok yani sadece ipic varsa biraz yetersiz kalacaktr motor

void ModeliKapla(GLuint texid)
{
	if(kaplamali == 1) // kaplamal m deil mi diye test edelim yoksa model formatmzdaki
					   // kaplama olayn belirleyen ibare hibir anlam tamaz
	{
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, texid);
	}
}

GLvoid ReSizeGLScene(GLsizei width, GLsizei height)		// Resize And Initialize The GL Window
{
	if (height==0)										// Prevent A Divide By Zero By
	{
		height=1;										// Making Height Equal One
	}

	glViewport(0,0,width,height);						// Reset The Current Viewport

	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix

	// Calculate The Aspect Ratio Of The Window
	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,100.0f);

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix
}

int InitGL(GLvoid)										// All Setup For OpenGL Goes Here
{
	glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);				// Black Background
	glClearDepth(1.0f);									// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
	glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations
	
	if(!BuildTexture("Wall.bmp",texture[0]))
		return FALSE;
	
	ModelYukle("poligon.m");

		return TRUE;										// Initialization Went OK
}

int DrawGLScene(GLvoid)									// Here's Where We Do All The Drawing
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear Screen And Depth Buffer
	glLoadIdentity();									// Reset The Current Modelview Matrix

	glTranslatef(0,0,-5);
	ModeliKapla(texture[0]);// Modelimizi yklettiimiz kaplamayla kaplyoruz...
	ModelCiz();				// ve izdiriyoruz
	
	return TRUE;										// Everything Went OK
}

GLvoid KillGLWindow(GLvoid)								// Properly Kill The Window
{
	if (fullscreen)										// Are We In Fullscreen Mode?
	{
		ChangeDisplaySettings(NULL,0);					// If So Switch Back To The Desktop
		ShowCursor(TRUE);								// Show Mouse Pointer
	}

	if (hRC)											// Do We Have A Rendering Context?
	{
		if (!wglMakeCurrent(NULL,NULL))					// Are We Able To Release The DC And RC Contexts?
		{
			MessageBox(NULL,"Release Of DC And RC Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}

		if (!wglDeleteContext(hRC))						// Are We Able To Delete The RC?
		{
			MessageBox(NULL,"Release Rendering Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}
		hRC=NULL;										// Set RC To NULL
	}

	if (hDC && !ReleaseDC(hWnd,hDC))					// Are We Able To Release The DC
	{
		MessageBox(NULL,"Release Device Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hDC=NULL;										// Set DC To NULL
	}

	if (hWnd && !DestroyWindow(hWnd))					// Are We Able To Destroy The Window?
	{
		MessageBox(NULL,"Could Not Release hWnd.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hWnd=NULL;										// Set hWnd To NULL
	}

	if (!UnregisterClass("OpenGL",hInstance))			// Are We Able To Unregister Class
	{
		MessageBox(NULL,"Could Not Unregister Class.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hInstance=NULL;									// Set hInstance To NULL
	}
}

/*	This Code Creates Our OpenGL Window.  Parameters Are:					*
 *	title			- Title To Appear At The Top Of The Window				*
 *	width			- Width Of The GL Window Or Fullscreen Mode				*
 *	height			- Height Of The GL Window Or Fullscreen Mode			*
 *	bits			- Number Of Bits To Use For Color (8/16/24/32)			*
 *	fullscreenflag	- Use Fullscreen Mode (TRUE) Or Windowed Mode (FALSE)	*/
 
BOOL CreateGLWindow(char* title, int width, int height, int bits, bool fullscreenflag)
{
	GLuint		PixelFormat;			// Holds The Results After Searching For A Match
	WNDCLASS	wc;						// Windows Class Structure
	DWORD		dwExStyle;				// Window Extended Style
	DWORD		dwStyle;				// Window Style
	RECT		WindowRect;				// Grabs Rectangle Upper Left / Lower Right Values
	WindowRect.left=(long)0;			// Set Left Value To 0
	WindowRect.right=(long)width;		// Set Right Value To Requested Width
	WindowRect.top=(long)0;				// Set Top Value To 0
	WindowRect.bottom=(long)height;		// Set Bottom Value To Requested Height

	fullscreen=fullscreenflag;			// Set The Global Fullscreen Flag

	hInstance			= GetModuleHandle(NULL);				// Grab An Instance For Our Window
	wc.style			= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;	// Redraw On Size, And Own DC For Window.
	wc.lpfnWndProc		= (WNDPROC) WndProc;					// WndProc Handles Messages
	wc.cbClsExtra		= 0;									// No Extra Window Data
	wc.cbWndExtra		= 0;									// No Extra Window Data
	wc.hInstance		= hInstance;							// Set The Instance
	wc.hIcon			= LoadIcon(NULL, IDI_WINLOGO);			// Load The Default Icon
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);			// Load The Arrow Pointer
	wc.hbrBackground	= NULL;									// No Background Required For GL
	wc.lpszMenuName		= NULL;									// We Don't Want A Menu
	wc.lpszClassName	= "OpenGL";								// Set The Class Name

	if (!RegisterClass(&wc))									// Attempt To Register The Window Class
	{
		MessageBox(NULL,"Failed To Register The Window Class.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;											// Return FALSE
	}
	
	if (fullscreen)												// Attempt Fullscreen Mode?
	{
		DEVMODE dmScreenSettings;								// Device Mode
		memset(&dmScreenSettings,0,sizeof(dmScreenSettings));	// Makes Sure Memory's Cleared
		dmScreenSettings.dmSize=sizeof(dmScreenSettings);		// Size Of The Devmode Structure
		dmScreenSettings.dmPelsWidth	= width;				// Selected Screen Width
		dmScreenSettings.dmPelsHeight	= height;				// Selected Screen Height
		dmScreenSettings.dmBitsPerPel	= bits;					// Selected Bits Per Pixel
		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

		// Try To Set Selected Mode And Get Results.  NOTE: CDS_FULLSCREEN Gets Rid Of Start Bar.
		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{
			// If The Mode Fails, Offer Two Options.  Quit Or Use Windowed Mode.
			if (MessageBox(NULL,"The Requested Fullscreen Mode Is Not Supported By\nYour Video Card. Use Windowed Mode Instead?","NeHe GL",MB_YESNO|MB_ICONEXCLAMATION)==IDYES)
			{
				fullscreen=FALSE;		// Windowed Mode Selected.  Fullscreen = FALSE
			}
			else
			{
				// Pop Up A Message Box Letting User Know The Program Is Closing.
				MessageBox(NULL,"Program Will Now Close.","ERROR",MB_OK|MB_ICONSTOP);
				return FALSE;									// Return FALSE
			}
		}
	}

	if (fullscreen)												// Are We Still In Fullscreen Mode?
	{
		dwExStyle=WS_EX_APPWINDOW;								// Window Extended Style
		dwStyle=WS_POPUP;										// Windows Style
		ShowCursor(FALSE);										// Hide Mouse Pointer
	}
	else
	{
		dwExStyle=WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;			// Window Extended Style
		dwStyle=WS_OVERLAPPEDWINDOW;							// Windows Style
	}

	AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);		// Adjust Window To True Requested Size

	// Create The Window
	if (!(hWnd=CreateWindowEx(	dwExStyle,							// Extended Style For The Window
								"OpenGL",							// Class Name
								title,								// Window Title
								dwStyle |							// Defined Window Style
								WS_CLIPSIBLINGS |					// Required Window Style
								WS_CLIPCHILDREN,					// Required Window Style
								0, 0,								// Window Position
								WindowRect.right-WindowRect.left,	// Calculate Window Width
								WindowRect.bottom-WindowRect.top,	// Calculate Window Height
								NULL,								// No Parent Window
								NULL,								// No Menu
								hInstance,							// Instance
								NULL)))								// Dont Pass Anything To WM_CREATE
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Window Creation Error.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	static	PIXELFORMATDESCRIPTOR pfd=				// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
		1,											// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,							// Must Support Double Buffering
		PFD_TYPE_RGBA,								// Request An RGBA Format
		bits,										// Select Our Color Depth
		0, 0, 0, 0, 0, 0,							// Color Bits Ignored
		0,											// No Alpha Buffer
		0,											// Shift Bit Ignored
		0,											// No Accumulation Buffer
		0, 0, 0, 0,									// Accumulation Bits Ignored
		16,											// 16Bit Z-Buffer (Depth Buffer)  
		0,											// No Stencil Buffer
		0,											// No Auxiliary Buffer
		PFD_MAIN_PLANE,								// Main Drawing Layer
		0,											// Reserved
		0, 0, 0										// Layer Masks Ignored
	};
	
	if (!(hDC=GetDC(hWnd)))							// Did We Get A Device Context?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Create A GL Device Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(PixelFormat=ChoosePixelFormat(hDC,&pfd)))	// Did Windows Find A Matching Pixel Format?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Find A Suitable PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if(!SetPixelFormat(hDC,PixelFormat,&pfd))		// Are We Able To Set The Pixel Format?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Set The PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(hRC=wglCreateContext(hDC)))				// Are We Able To Get A Rendering Context?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Create A GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if(!wglMakeCurrent(hDC,hRC))					// Try To Activate The Rendering Context
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Activate The GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	ShowWindow(hWnd,SW_SHOW);						// Show The Window
	SetForegroundWindow(hWnd);						// Slightly Higher Priority
	SetFocus(hWnd);									// Sets Keyboard Focus To The Window
	ReSizeGLScene(width, height);					// Set Up Our Perspective GL Screen

	if (!InitGL())									// Initialize Our Newly Created GL Window
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Initialization Failed.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	return TRUE;									// Success
}

LRESULT CALLBACK WndProc(	HWND	hWnd,			// Handle For This Window
							UINT	uMsg,			// Message For This Window
							WPARAM	wParam,			// Additional Message Information
							LPARAM	lParam)			// Additional Message Information
{
	switch (uMsg)									// Check For Windows Messages
	{
		case WM_ACTIVATE:							// Watch For Window Activate Message
		{
			if (!HIWORD(wParam))					// Check Minimization State
			{
				active=TRUE;						// Program Is Active
			}
			else
			{
				active=FALSE;						// Program Is No Longer Active
			}

			return 0;								// Return To The Message Loop
		}

		case WM_SYSCOMMAND:							// Intercept System Commands
		{
			switch (wParam)							// Check System Calls
			{
				case SC_SCREENSAVE:					// Screensaver Trying To Start?
				case SC_MONITORPOWER:				// Monitor Trying To Enter Powersave?
				return 0;							// Prevent From Happening
			}
			break;									// Exit
		}

		case WM_CLOSE:								// Did We Receive A Close Message?
		{
			PostQuitMessage(0);						// Send A Quit Message
			return 0;								// Jump Back
		}

		case WM_KEYDOWN:							// Is A Key Being Held Down?
		{
			keys[wParam] = TRUE;					// If So, Mark It As TRUE
			return 0;								// Jump Back
		}

		case WM_KEYUP:								// Has A Key Been Released?
		{
			keys[wParam] = FALSE;					// If So, Mark It As FALSE
			return 0;								// Jump Back
		}

		case WM_SIZE:								// Resize The OpenGL Window
		{
			ReSizeGLScene(LOWORD(lParam),HIWORD(lParam));  // LoWord=Width, HiWord=Height
			return 0;								// Jump Back
		}
	}

	// Pass All Unhandled Messages To DefWindowProc
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}

int WINAPI WinMain(	HINSTANCE	hInstance,			// Instance
					HINSTANCE	hPrevInstance,		// Previous Instance
					LPSTR		lpCmdLine,			// Command Line Parameters
					int			nCmdShow)			// Window Show State
{
	MSG		msg;									// Windows Message Structure
	BOOL	done=FALSE;								// Bool Variable To Exit Loop

	// Ask The User Which Screen Mode They Prefer
	if (MessageBox(NULL,"Would You Like To Run In Fullscreen Mode?", "Start FullScreen?",MB_YESNO|MB_ICONQUESTION)==IDNO)
	{
		fullscreen=FALSE;							// Windowed Mode
	}

	// Create Our OpenGL Window
	if (!CreateGLWindow("NeHe's OpenGL Framework",640,480,16,fullscreen))
	{
		return 0;									// Quit If Window Was Not Created
	}

	while(!done)									// Loop That Runs While done=FALSE
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))	// Is There A Message Waiting?
		{
			if (msg.message==WM_QUIT)				// Have We Received A Quit Message?
			{
				done=TRUE;							// If So done=TRUE
			}
			else									// If Not, Deal With Window Messages
			{
				TranslateMessage(&msg);				// Translate The Message
				DispatchMessage(&msg);				// Dispatch The Message
			}
		}
		else										// If There Are No Messages
		{
			// Draw The Scene.  Watch For ESC Key And Quit Messages From DrawGLScene()
			if (active)								// Program Active?
			{
				if (keys[VK_ESCAPE])				// Was ESC Pressed?
				{
					done=TRUE;						// ESC Signalled A Quit
				}
				else								// Not Time To Quit, Update Screen
				{
					DrawGLScene();					// Draw The Scene
					SwapBuffers(hDC);				// Swap Buffers (Double Buffering)
				}
			}

			if (keys[VK_F1])						// Is F1 Being Pressed?
			{
				keys[VK_F1]=FALSE;					// If So Make Key FALSE
				KillGLWindow();						// Kill Our Current Window
				fullscreen=!fullscreen;				// Toggle Fullscreen / Windowed Mode
				// Recreate Our OpenGL Window
				if (!CreateGLWindow("NeHe's OpenGL Framework",640,480,16,fullscreen))
				{
					return 0;						// Quit If Window Was Not Created
				}
			}
		}
	}

	// Shutdown
	KillGLWindow();									// Kill The Window
	return (msg.wParam);							// Exit The Program
}


// Evet basite aklamak gerekirse kendimize ait text tabanl <<henz>> binary olmayan bir model format
// oluturduk. Mmkn olan en ksa zamanda iskelet sistemini de eklemeyi ve ders olarak datmay
// dnyorum ve son olarak teekkrler:
/*
Oyunyapimi.org gibi bir adresi bizlere kazandrd iin ncelikle deniz'e
Kodlardaki baz yerleri aldm frustum.org'a
Benim opengl'de bu seviyeye gelmeme yardmc olduklar iin VEDAT MEYDANER (VMEYDANER)
ve LEVENT SEVGL'ye (LOREN SOTH) ooook ama ooooook byk teekkrlerimi sunarm ve tabii adn
saymay unuttuum herkese. ok teekkrler
*/