//========================================================================
//    NeHe OpenGL Wizard : NeHe_IPicture.cpp
//    Wizard Created by: Vic Hollis
//========================================================================
/****************************************************************************
*                                     *                                     *
*  Jeff Molofee's IPicture Basecode   *    Huge Thanks To: Dave Richards    *
*       http://nehe.gamedev.net       *                    Bobby Ward &     *
*                2002                 *                    The MSDN         *
*                                     *                                     *
*****************************************************************************
*                                                                           *
*   Loads  : BMP, EMF, GIF, ICO, JPG, WMF                                   *
*   Source : Reads From Disk Or The Internet                                *
*   Extras : Images Can Be Any Width Or Height                              *
*                                                                           *
*****************************************************************************
*                                                                           *
*   ReshapeGL  : Set Your Aspect Ratio, How You Want                        *
*   WindowProc : Add Custom WM_ Events (Mouse, Etc)                         *
*   WinMain    : Set The Window Title                                       *
*                Set Resolution & Color Depth                               *
*                Remove 4 Lines Of Code To Force Fullscreen (Commented)     *
*                                                                           *
*****************************************************************************
*                                                                           *
*   Free To Use In Projects Of Your Own.  All I Ask For Is A Simple Greet   *
*   Or Mention Of The Site In Your Readme Or The Project Itself :)          *
*                                                                           *
****************************************************************************/

#include <windows.h>													// Header File For Windows
#include <gl\gl.h>														// Header File For The OpenGL32 Library
#include <gl\glu.h>														// Header File For The GLu32 Library
#include <olectl.h>														// Header File For The OLE Controls Library	(Used In BuildTexture)
#include <math.h>														// Header File For The Math Library			(Used In BuildTexture)

int BuildTexture(char *szPathName, GLuint &texid)						// Load Image And Convert To A Texture
{
	HDC			hdcTemp;												// The DC To Hold Our Bitmap
	HBITMAP		hbmpTemp;												// Holds The Bitmap Temporarily
	IPicture	*pPicture;												// IPicture Interface
	OLECHAR		wszPath[MAX_PATH+1];									// Full Path To Picture (WCHAR)
	char		szPath[MAX_PATH+1];										// Full Path To Picture
	long		lWidth;													// Width In Logical Units
	long		lHeight;												// Height In Logical Units
	long		lWidthPixels;											// Width In Pixels
	long		lHeightPixels;											// Height In Pixels
	GLint		glMaxTexDim ;											// Holds Maximum Texture Size

	if (strstr(szPathName, "http://"))									// If PathName Contains http:// Then...
	{
		strcpy(szPath, szPathName);										// Append The PathName To szPath
	}
	else																// Otherwise... We Are Loading From A File
	{
		GetCurrentDirectory(MAX_PATH, szPath);							// Get Our Working Directory
		strcat(szPath, "\\");											// Append "\" After The Working Directory
		strcat(szPath, szPathName);										// Append The PathName
	}

	MultiByteToWideChar(CP_ACP, 0, szPath, -1, wszPath, MAX_PATH);		// Convert From ASCII To Unicode
	HRESULT hr = OleLoadPicturePath(wszPath, 0, 0, 0, IID_IPicture, (void**)&pPicture);

	if(FAILED(hr))														// If Loading Failed
		return FALSE;													// Return False

	hdcTemp = CreateCompatibleDC(GetDC(0));								// Create The Windows Compatible Device Context
	if(!hdcTemp)														// Did Creation Fail?
	{
		pPicture->Release();											// Decrements IPicture Reference Count
		return FALSE;													// Return False (Failure)
	}

	glGetIntegerv(GL_MAX_TEXTURE_SIZE, &glMaxTexDim);					// Get Maximum Texture Size Supported
	
	pPicture->get_Width(&lWidth);										// Get IPicture Width (Convert To Pixels)
	lWidthPixels	= MulDiv(lWidth, GetDeviceCaps(hdcTemp, LOGPIXELSX), 2540);
	pPicture->get_Height(&lHeight);										// Get IPicture Height (Convert To Pixels)
	lHeightPixels	= MulDiv(lHeight, GetDeviceCaps(hdcTemp, LOGPIXELSY), 2540);

	// Resize Image To Closest Power Of Two
	if (lWidthPixels <= glMaxTexDim) // Is Image Width Less Than Or Equal To Cards Limit
		lWidthPixels = 1 << (int)floor((log((double)lWidthPixels)/log(2.0f)) + 0.5f); 
	else  // Otherwise  Set Width To "Max Power Of Two" That The Card Can Handle
		lWidthPixels = glMaxTexDim;
 
	if (lHeightPixels <= glMaxTexDim) // Is Image Height Greater Than Cards Limit
		lHeightPixels = 1 << (int)floor((log((double)lHeightPixels)/log(2.0f)) + 0.5f);
	else  // Otherwise  Set Height To "Max Power Of Two" That The Card Can Handle
		lHeightPixels = glMaxTexDim;
	
	//	Create A Temporary Bitmap
	BITMAPINFO	bi = {0};												// The Type Of Bitmap We Request
	DWORD		*pBits = 0;												// Pointer To The Bitmap Bits

	bi.bmiHeader.biSize			= sizeof(BITMAPINFOHEADER);				// Set Structure Size
	bi.bmiHeader.biBitCount		= 32;									// 32 Bit
	bi.bmiHeader.biWidth		= lWidthPixels;							// Power Of Two Width
	bi.bmiHeader.biHeight		= lHeightPixels;						// Make Image Top Up (Positive Y-Axis)
	bi.bmiHeader.biCompression	= BI_RGB;								// RGB Encoding
	bi.bmiHeader.biPlanes		= 1;									// 1 Bitplane

	//	Creating A Bitmap This Way Allows Us To Specify Color Depth And Gives Us Imediate Access To The Bits
	hbmpTemp = CreateDIBSection(hdcTemp, &bi, DIB_RGB_COLORS, (void**)&pBits, 0, 0);
	
	if(!hbmpTemp)														// Did Creation Fail?
	{
		DeleteDC(hdcTemp);												// Delete The Device Context
		pPicture->Release();											// Decrements IPicture Reference Count
		return FALSE;													// Return False (Failure)
	}

	SelectObject(hdcTemp, hbmpTemp);									// Select Handle To Our Temp DC And Our Temp Bitmap Object

	// Render The IPicture On To The Bitmap
	pPicture->Render(hdcTemp, 0, 0, lWidthPixels, lHeightPixels, 0, lHeight, lWidth, -lHeight, 0);

	// Convert From BGR To RGB Format And Add An Alpha Value Of 255
	for(long i = 0; i < lWidthPixels * lHeightPixels; i++)				// Loop Through All Of The Pixels
	{
		BYTE* pPixel	= (BYTE*)(&pBits[i]);							// Grab The Current Pixel
		BYTE  temp		= pPixel[0];									// Store 1st Color In Temp Variable (Blue)
		pPixel[0]		= pPixel[2];									// Move Red Value To Correct Position (1st)
		pPixel[2]		= temp;											// Move Temp Value To Correct Blue Position (3rd)

		// This Will Make Any Black Pixels, Completely Transparent		(You Can Hardcode The Value If You Wish)
		if ((pPixel[0]==0) && (pPixel[1]==0) && (pPixel[2]==0))			// Is Pixel Completely Black
			pPixel[3]	=   0;											// Set The Alpha Value To 0
		else															// Otherwise
			pPixel[3]	= 255;											// Set The Alpha Value To 255
	}

	glGenTextures(1, &texid);											// Create The Texture

	// Typical Texture Generation Using Data From The Bitmap
	glBindTexture(GL_TEXTURE_2D, texid);								// Bind To The Texture ID
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);		// (Modify This For The Type Of Filtering You Want)
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);     // (Modify This For The Type Of Filtering You Want)
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, lWidthPixels, lHeightPixels, 0, GL_RGBA, GL_UNSIGNED_BYTE, pBits);	// (Modify This If You Want Mipmaps)

	DeleteObject(hbmpTemp);												// Delete The Object
	DeleteDC(hdcTemp);													// Delete The Device Context

	pPicture->Release();												// Decrements IPicture Reference Count

	return TRUE;														// Return True (All Good)
}

//////////////////////////////////////////////////////////////////////////////////
// THIS CODE WAS COMMENTED OUT TO AVOID NAMING COLLISIONS BY NeHe OpenGL Wizard
// IT WAS LEFT HERE AS A REFERENCE FOR USING THE IPICTURE SOURCE CODE.
//////////////////////////////////////////////////////////////////////////////////
//BOOL Initialize (GL_Window* window, Keys* keys)							// Any GL Init Code & User Initialiazation Goes Here
//{
//	g_window	= window;												// Window Values
//	g_keys		= keys;													// Key Values
//
//	// Start Of User Initialization
//
//	// Load .BMP From A File		(1st Texture)
//	if (!BuildTexture("Data/NeHe.bmp", texture[0]))																// (Example Code... Can Be Removed)
//		return FALSE;													// Return False If Loading Failed		// (Example Code... Can Be Removed)
//
//	// Load .JPG From A URL			(2nd Texture)																// (Example Code... Can Be Removed)
//	if (!BuildTexture("http://nehe.gamedev.net/data/downloads/o/opalis.jpg", texture[1]))						// (Example Code... Can Be Removed)
//		return FALSE;													// Return False If Loading Failed		// (Example Code... Can Be Removed)
//
//	// Load .GIF From A File		(3rd Texture)																// (Example Code... Can Be Removed)
//	if (!BuildTexture("Data/lady.gif", texture[2]))																// (Example Code... Can Be Removed)
//		return FALSE;													// Return False If Loading Failed		// (Example Code... Can Be Removed)
//
//	glEnable(GL_TEXTURE_2D);											// Enable Texture Mapping				// (Example Code... Can Be Removed)
//	glClearColor (0.0f, 0.0f, 0.0f, 0.5f);								// Black Background						// (Set To Any Color You Wish)
//	glClearDepth (1.0f);												// Depth Buffer Setup
//	glDepthFunc (GL_LEQUAL);											// The Type Of Depth Testing			// (Select The Depth Testing You Want)
//	glEnable (GL_DEPTH_TEST);											// Enable Depth Testing
//	glShadeModel (GL_SMOOTH);											// Select Smooth Shading				// (Set To Flat Shading If You Wish)
//	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);					// Set Perspective Calculations To Most Accurate
//
//	glAlphaFunc(GL_GREATER,0.1f);										// Set Alpha Testing (To Make Black Transparent)
//	glEnable(GL_ALPHA_TEST);											// Enable Alpha Testing (To Make Black Transparent)
//	return TRUE;														// Return TRUE (Initialization Successful)
//}
//
//void Deinitialize (void)												// Any User DeInitialization Goes Here
//{
//}
//
//void Update (float milliseconds)										// Perform Motion Updates Here
//{
//	if (g_keys->keyDown [VK_ESCAPE])									// Is ESC Being Pressed?
//		TerminateApplication (g_window);								// Terminate The Program
//
//	if (g_keys->keyDown [VK_F1])										// Is F1 Being Pressed?
//		ToggleFullscreen (g_window);									// Toggle Fullscreen Mode
//
//	xrot+=(float)(milliseconds)/32.0f;									// Increase X Rotation					// (Example Code... Can Be Removed)
//	yrot+=(float)(milliseconds)/16.0f;									// Increase Y Rotation					// (Example Code... Can Be Removed)
//	zrot+=(float)(milliseconds)/48.0f;									// Increase Z Rotation					// (Example Code... Can Be Removed)
//}
//
//void Draw (void)
//{
//	glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);				// Clear Screen And Depth Buffer
//	glLoadIdentity ();													// Reset The Modelview Matrix
//
//	glTranslatef(0.0f,0.0f,-5.0f);										// Translate 5 Units Into The Screen	// (Modify To A Depth You Want)
//
//	glRotatef(xrot,1.0f,0.0f,0.0f);										// Rotate On The X-Axis					// (Example Code... Can Be Removed)
//	glRotatef(yrot,0.0f,1.0f,0.0f);										// Rotate On The Y-Axis					// (Example Code... Can Be Removed)
//	glRotatef(zrot,0.0f,0.0f,1.0f);										// Rotate On The Z-Axis					// (Example Code... Can Be Removed)
//
//	glBindTexture(GL_TEXTURE_2D, texture[0]);							// Select The 1st Texture				// (Example Code... Can Be Removed)
//
//	glBegin(GL_QUADS);													// Begin Drawing Quads					// (Example Code... Can Be Removed)
//		// Front Face																							// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		// Back Face																							// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);												// (Example Code... Can Be Removed)
//	glEnd();															// Done Drawing Quads					// (Example Code... Can Be Removed)
//
//	glBindTexture(GL_TEXTURE_2D, texture[1]);							// Select The 2nd Texture				// (Example Code... Can Be Removed)
//
//	glBegin(GL_QUADS);													// Begin Drawing Quads					// (Example Code... Can Be Removed)
//		// Top Face																								// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,  1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,  1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);												// (Example Code... Can Be Removed)
//		// Bottom Face																							// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f, -1.0f, -1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f, -1.0f, -1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);												// (Example Code... Can Be Removed)
//	glEnd();															// Done Drawing Quads					// (Example Code... Can Be Removed)
//
//	glBindTexture(GL_TEXTURE_2D, texture[2]);							// Select The 3rd Texture				// (Example Code... Can Be Removed)
//
//	glBegin(GL_QUADS);													// Begin Drawing Quads					// (Example Code... Can Be Removed)
//		// Right Face																							// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		// Left Face																							// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);												// (Example Code... Can Be Removed)
//		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);												// (Example Code... Can Be Removed)
//	glEnd();															// Done Drawing Quads					// (Example Code... Can Be Removed)
//
//	glFlush ();															// Flush The GL Rendering Pipeline
//}
