//-----------------------------------------------------------------------
// OpenGL Pencere minumum izim iin gerekli bir kalp
// Oyunyapimi.org iin hazirlanmistir.
//-----------------------------------------------------------------------
// Proje Adi  : GLWOY ( GL window oyunyapimi.org framework)
// Hazirliyan : Vedat Meydaneri
// Ama       : OpenGL Pencere modunda alan minumum bir kalp
// Tarih      : 11/04/2005
//-----------------------------------------------------------------------
// Hazirlama amam ise oyunyapimi.org 'a Opengl rnek hazirlamak isteyen 
// arkadaslarin pencere gereksinimi ile uramadan direkt rnei 
// hazirlamaya younlamalarini salamak bylece bunun iin zaman
// kaybetmemelerini salamak.
//-----------------------------------------------------------------------
// Anakaynak.cpp
//-----------------------------------------------------------------------

//balklarimizi tanimliyalim
#include "basliklar.h"

CPencere::CPencere(void)
{
    hInst=NULL;		
    hWnd=NULL;
    hdc=NULL;   //windows icin
    hRC=NULL; //opengl icin
	px=0;
	py=0;
}

CPencere::~CPencere(void)
{

}
//Uyari mesaji
void CPencere::uyari(char *hataadi) 
{
  MessageBox(hWnd,hataadi,szTanim,MB_OK | MB_ICONEXCLAMATION);
}
//Saniyede izilen kare sayisi
void CPencere::FPShesapla()
{ 
	fps.suankiZaman = timeGetTime()*0.001f;
	fps.dt = fps.suankiZaman - fps.kareZamani;
	fps.kareZamani = fps.suankiZaman;
    ++fps.kare;

    if( fps.suankiZaman - fps.oncekiZaman > 1.0f )
    {	fps.oncekiZaman = fps.suankiZaman;
		fps.fps = fps.kare;
	    fps.kare = 0;
    }
}
GLuint CPencere::Dokuyukle(char *dosyaadi)	
{
	AUX_RGBImageRec *pDoku = auxDIBImageLoad( dosyaadi );
	GLuint d_doku=-1;

    if( pDoku != NULL )
	{
        glGenTextures( 1, &d_doku );

		glBindTexture( GL_TEXTURE_2D, d_doku );

		glTexParameteri( GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER, GL_LINEAR );
		glTexParameteri( GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER, GL_LINEAR );

		glTexImage2D(GL_TEXTURE_2D, 0, 3, pDoku->sizeX, pDoku->sizeY, 0,GL_RGB, GL_UNSIGNED_BYTE, pDoku->data );
	}

	if( pDoku )
	{
		if( pDoku->data )
			free( pDoku->data );
		free( pDoku );
	}

	return d_doku; 
}
//Pencere kapatilirken yapilaak islemler
void CPencere::Pencere_kapat(void)
{
	if (hRC)										
	{
		if (!wglMakeCurrent(NULL,NULL))					
		{
		uyari("DC ve RC kaldirilamadi!");
		}
		if (!wglDeleteContext(hRC))					
		{ 
		uyari("RC context kaldirilamadi!");
		}
		hRC=NULL;									
	}

	if (hdc && !ReleaseDC(hWnd,hdc))				
	{
		uyari("DC kaldirilamadi!");
		hdc=NULL;									
	}

	if (hWnd && !DestroyWindow(hWnd))					
	{
		uyari("Pencere Kaldirilamadi!");
		hWnd=NULL;									
	}
								
	if (!UnregisterClass(szPencereSinifi,hInst))			
	{
	   uyari("Pencere Kayittan kaldirilamadi!");
	   hInst=NULL;							
	}

}
BOOL CPencere::PikselAyari(int zbuffer,int renk)
{
	int		pikselformati;

	static	PIXELFORMATDESCRIPTOR pfd=			
	{
		sizeof(PIXELFORMATDESCRIPTOR),			
		1,										
		PFD_DRAW_TO_WINDOW |					
		PFD_SUPPORT_OPENGL |					
		PFD_DOUBLEBUFFER,						
		PFD_TYPE_RGBA,							
		renk,									
		0, 0, 0, 0, 0, 0,						
		0,											
		0,										
		0,										
		0, 0, 0, 0,								
		zbuffer,	//Z Buffer							
		0,	//Stencil									
		0,										
		PFD_MAIN_PLANE,							
		0,											
		0, 0, 0										
	};
	
	if (!(hdc=GetDC(hWnd)))							
	{	uyari("OpenGL hatasi Opengl Context aygiti olusuturulamadi.");
		return FALSE;							
	}
	if (!(pikselformati=ChoosePixelFormat(hdc,&pfd)))
	{			
		uyari("Suitable PikselFormat bulunamadi!");
		return FALSE;								
	}
	if(!SetPixelFormat(hdc,pikselformati,&pfd))		
	{
		uyari("PikselFormat ayarlanamadi!");
		return FALSE;								
	}

	if (!(hRC=wglCreateContext(hdc)))				
	{
    	uyari("OpenGL rendering context olusturulamadi!");
		return FALSE;								
	}

	if(!wglMakeCurrent(hdc,hRC))					
	{
		uyari("OpenGL rendering context aktif hale getirilemedi.");
		return FALSE;							
	}

	return TRUE;
}
GLvoid CPencere::SahneyiTekrarCiz(GLsizei en, GLsizei boy)		
{
    if (boy==0)										
	{
	boy=1;									
	}
	glViewport(0,0,en,boy);					

	glMatrixMode(GL_PROJECTION);						
	glLoadIdentity();								

	gluPerspective(50,(GLfloat)en/(GLfloat)boy,1.0f,1500);

	glMatrixMode(GL_MODELVIEW);						
	glLoadIdentity();								
}
BOOL CPencere::OpenGLGiris(int px,int py)
{	
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);			
	glClearDepth(1.0f);		
	glShadeModel(GL_SMOOTH);
    glDepthFunc (GL_LEQUAL);
  	glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);	
	
	glEnable(GL_TEXTURE_2D);							
	glEnable(GL_DEPTH_TEST);

    glDepthMask(true);

 	SahneyiTekrarCiz(px,py);

	return TRUE;
}
BOOL CPencere::OpenGLOlustur(int px,int py)
{	
	//opengl pixel ayari
	if(!PikselAyari(16,16))
	{
		return FALSE;
	}
	 //opengl giris ayari
	if(!OpenGLGiris(px,py))
	{return FALSE;
	}
	return TRUE;
}
BOOL CPencere::PencereOlustur(HINSTANCE hInstance,int ekranx,int ekrany,char *tanim,char *penceresinifi, int nCmdShow)
{ 
	if(penceresinifi==NULL)
	{
		uyari("Pencere sinifi girilmemis.");
		return false;
	}
	sprintf(szPencereSinifi,"%s",penceresinifi);
	if(tanim==NULL)
	{
		uyari("Pencere adi girilmemis.");
		return false;
	}
	sprintf(szTanim,"%s",tanim);

	px = ekranx;
	py = ekrany;

	WNDCLASSEX wcex;

	hInst				=GetModuleHandle(NULL);	
	hInst = hInstance; 

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance,IDI_WINLOGO);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.lpszClassName	= (LPCSTR)szPencereSinifi;
	wcex.hbrBackground	=NULL;				
	wcex.lpszMenuName	=NULL;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_WINLOGO);
	
   if(!RegisterClassEx(&wcex))		
	{
	uyari("Pencere Kayit edilemedi.");
	return FALSE;
	}

   hWnd = CreateWindow(szPencereSinifi, szTanim, GLWOY_PENCERE,
      0,0,px,py, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   { 
	   uyari("Pencere oluturulamadi.");
	   return FALSE;
   }
   if(!OpenGLOlustur(px,py))
   {
	 uyari("Giris degerleri girilemedi.");
   return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}
//2 Boyutlu izim yapmak iin
void CPencere::Ekrana2BCizimyap(int acikkapali)
{	if (acikkapali == ACIK)
	{
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glLoadIdentity();
		glEnable(GL_TEXTURE_2D);
		glOrtho(0, px, 0, py, -10,10);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glDisable(GL_DEPTH_TEST);	
		glDisable(GL_BLEND);

	}
	else if (acikkapali == KAPALI)
	{
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
		glMatrixMode(GL_MODELVIEW);
		glEnable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);
	}
}
//Basta OpenGL penceremizde neden izilmis nesneleri temizliyelim
void CPencere::Temizle()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	
	glLoadIdentity();										
}
//Son olarak ekrandaki nesneleri cizelim ve sonraki kareye geelim
void CPencere::KareyiCizveCevir()
{
    SwapBuffers(hdc);	
	FPShesapla();
}